/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.core.api.MuleContext;

@NoInstantiate
public final class MuleContextNotification
extends AbstractServerNotification {
    private static final long serialVersionUID = -3246036188011581121L;
    public static final int CONTEXT_INITIALISING = 101;
    public static final int CONTEXT_INITIALISED = 102;
    public static final int CONTEXT_STARTING = 103;
    public static final int CONTEXT_STARTED = 104;
    public static final int CONTEXT_STOPPING = 105;
    public static final int CONTEXT_STOPPED = 106;
    public static final int CONTEXT_DISPOSING = 107;
    public static final int CONTEXT_DISPOSED = 108;
    private String clusterId;
    private String domain;
    private transient MuleContext muleContext;

    public MuleContextNotification(MuleContext context, String action) {
        this(context, MuleContextNotification.getActionId(action));
    }

    public MuleContextNotification(MuleContext context, int action) {
        super(context.getId(), action);
        this.muleContext = context;
        this.resourceIdentifier = context.getConfiguration().getId();
        this.clusterId = context.getClusterId();
        this.domain = context.getConfiguration().getDomainId();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getDomain() {
        return this.domain;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public String toString() {
        return this.getEventName() + "{action=" + MuleContextNotification.getActionName(this.action) + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + "}";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    @Override
    public String getEventName() {
        return "MuleContextNotification";
    }

    static {
        MuleContextNotification.registerAction("mule context initialising", 101);
        MuleContextNotification.registerAction("mule context initialised", 102);
        MuleContextNotification.registerAction("mule context starting", 103);
        MuleContextNotification.registerAction("mule context started", 104);
        MuleContextNotification.registerAction("mule context stopping", 105);
        MuleContextNotification.registerAction("mule context stopped", 106);
        MuleContextNotification.registerAction("mule context disposing", 107);
        MuleContextNotification.registerAction("mule context disposed", 108);
    }
}

