/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.validation.ArtifactAstValidatorBuilder;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationsProvider;
import org.mule.runtime.ast.internal.FilteredArtifactAst;
import org.mule.runtime.ast.internal.builder.LightComponentAstBuilder;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.internal.validation.DefaultValidatorBuilder;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleAstUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleAstUtils.class);
    private static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "]";
    private static final ExtensionModel CORE_EXT_MODEL = MuleAstUtils.getCoreExtensionModel();
    private static final ArtifactAst EMPTY_ARTIFACT = new BaseArtifactAst(){

        @Override
        public String getArtifactName() {
            return "<empty>";
        }

        @Override
        public ArtifactType getArtifactType() {
            return ArtifactType.APPLICATION;
        }

        @Override
        public Set<ExtensionModel> dependencies() {
            ExtensionModel coreExtModel = CORE_EXT_MODEL;
            if (MuleImplementationLoaderUtils.isResolveMuleImplementationLoadersDynamically()) {
                coreExtModel = MuleAstUtils.getCoreExtensionModel();
            }
            if (coreExtModel == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(coreExtModel);
        }

        @Override
        public Optional<ArtifactAst> getParent() {
            return Optional.empty();
        }

        @Override
        public List<ComponentAst> topLevelComponents() {
            return Collections.emptyList();
        }

        @Override
        public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
        }

        @Override
        public ErrorTypeRepository getErrorTypeRepository() {
            return ErrorTypeRepositoryProvider.getCoreErrorTypeRepo();
        }

        @Override
        public Collection<ImportedResource> getImportedResources() {
            return Collections.emptyList();
        }

        public String toString() {
            return "(empty artifactAst)";
        }
    };

    private static ExtensionModel getCoreExtensionModel() {
        ExtensionModel coreExtModel = null;
        try {
            Class<?> coreExtModelProviderClass = MuleImplementationLoaderUtils.getMuleImplementationsLoader().loadClass("org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider");
            coreExtModel = (ExtensionModel)coreExtModelProviderClass.getMethod("getExtensionModel", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.warn("{}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        return coreExtModel;
    }

    private MuleAstUtils() {
    }

    public static Set<ComponentAst> resolveOrphanComponents(ArtifactAst appModel) {
        Set notOrphanComponents = appModel.topLevelComponentsStream().filter(componentAst -> componentAst.getModel(ParameterizedModel.class).isPresent()).flatMap(ComponentAst::recursiveStream).collect(Collectors.toSet());
        notOrphanComponents.addAll(appModel.filteredComponents(cm -> !notOrphanComponents.contains(cm)).flatMap(ComponentAst::directChildrenStream).collect(Collectors.toSet()));
        return appModel.filteredComponents(cm -> !notOrphanComponents.contains(cm)).collect(Collectors.toSet());
    }

    public static ArtifactAst emptyArtifact() {
        return EMPTY_ARTIFACT;
    }

    public static Optional<ComponentParameterAst> parameterOfType(ComponentAst referent, StereotypeModel referenceStereotype) {
        return referent.getModel(ParameterizedModel.class).flatMap(parameterized -> ExtensionModelUtils.getGroupAndParametersPairs(parameterized).filter(pair -> ((ParameterModel)pair.getSecond()).getAllowedStereotypes().stream().anyMatch(allowed -> allowed.isAssignableTo(referenceStereotype))).map(pair -> referent.getParameter(((ParameterGroupModel)pair.getFirst()).getName(), ((ParameterModel)pair.getSecond()).getName())).findAny());
    }

    public static List<ComponentParameterAst> parametersOfType(ComponentAst referent, StereotypeModel referenceStereotype) {
        return referent.getModel(ParameterizedModel.class).map(parameterized -> ExtensionModelUtils.getGroupAndParametersPairs(parameterized).filter(pair -> ((ParameterModel)pair.getSecond()).getAllowedStereotypes().stream().anyMatch(allowed -> allowed.isAssignableTo(referenceStereotype))).map(pair -> referent.getParameter(((ParameterGroupModel)pair.getFirst()).getName(), ((ParameterModel)pair.getSecond()).getName())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static void doOnParamComponents(final ComponentParameterAst param, final Consumer<ComponentAst> action) {
        if (param.getModel().getName().equals("errorMappings")) {
            return;
        }
        param.getModel().getType().accept(new MetadataTypeVisitor(){

            @Override
            public void visitArrayType(ArrayType arrayType) {
                Object value = param.getValue().getRight();
                if (value != null && value instanceof Collection) {
                    ((Iterable)value).forEach(this::doAction);
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                Object value = param.getValue().getRight();
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    if (value != null && value instanceof Collection) {
                        ((Iterable)value).forEach(this::doAction);
                    }
                } else if (value instanceof ComponentAst) {
                    this.doAction(value);
                }
            }

            private void doAction(Object component) {
                if (component != null && component instanceof ComponentAst) {
                    action.accept((ComponentAst)component);
                }
            }
        });
    }

    public static Stream<Pair<ComponentAst, List<ComponentAst>>> recursiveStreamWithHierarchy(ArtifactAst artifact) {
        return MuleAstUtils.recursiveStreamWithHierarchy(artifact, AstTraversalDirection.TOP_DOWN, false);
    }

    public static Stream<Pair<ComponentAst, List<ComponentAst>>> recursiveStreamWithHierarchy(ArtifactAst artifact, AstTraversalDirection direction) {
        return MuleAstUtils.recursiveStreamWithHierarchy(artifact, direction, false);
    }

    public static Stream<Pair<ComponentAst, List<ComponentAst>>> recursiveStreamWithHierarchy(ArtifactAst artifact, AstTraversalDirection direction, boolean ignoreParameterComplexValues) {
        Set<ComponentAst> orphanComponents = MuleAstUtils.resolveOrphanComponents(artifact);
        if (orphanComponents.isEmpty()) {
            return direction.recursiveStreamWithHierarchy(artifact.topLevelComponentsStream(), ignoreParameterComplexValues);
        }
        ComponentAst orphanPhantomContainer = new LightComponentAstBuilder(new ParameterModelUtils()).withIdentifier(ComponentIdentifier.builder().namespace("mule").name("orphan-container").build()).build();
        return Stream.concat(direction.recursiveStreamWithHierarchy(artifact.topLevelComponentsStream()), direction.recursiveStreamWithHierarchy(orphanComponents.stream(), Collections.singletonList(orphanPhantomContainer)));
    }

    public static boolean hasPropertyPlaceholder(String v) {
        return v != null && v.contains("${");
    }

    public static ArtifactAstValidatorBuilder validatorBuilder() {
        return new DefaultValidatorBuilder();
    }

    public static <T extends ParameterizedModel> ComponentParameterization<T> createComponentParameterizationFromComponentAst(ComponentAst componentAst) {
        return componentAst.getModel(ParameterizedModel.class).map(model -> {
            ComponentParameterization.Builder<ParameterizedModel> builder = ComponentParameterization.builder(model);
            componentAst.getParameters().forEach(parameter -> MuleAstUtils.createComponentParameterizationFromComponentAstParameter(parameter.getValue(), parameter.getModel().getType()).ifPresent(v -> builder.withParameter(parameter.getGroupModel(), parameter.getModel(), v)));
            builder.withComponentIdentifier(componentAst.getIdentifier());
            return builder.build();
        }).orElseThrow(() -> new IllegalArgumentException("ComponentAst model must be a ParameterizedModel"));
    }

    private static Optional<Object> createComponentParameterizationFromComponentAstParameter(Either<String, Object> value, MetadataType type) {
        return value.mapLeft(expr -> DEFAULT_EXPRESSION_PREFIX + expr + DEFAULT_EXPRESSION_SUFFIX).mapRight(item -> MuleAstUtils.createComponentParameterizationFromFixedValueComponentAstParameter(item, type)).getValue();
    }

    private static Object createComponentParameterizationFromFixedValueComponentAstParameter(final Object v, MetadataType metadataType) {
        ComponentParameterization<Object> result = v;
        if (v instanceof ComponentAst) {
            result = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)((Object)v));
        } else if (v instanceof Collection) {
            if (ExtensionMetadataTypeUtils.isMap(metadataType)) {
                ObjectType mapType = (ObjectType)metadataType;
                final MetadataType entryType = mapType.getOpenRestriction().get();
                final AtomicReference mapResult = new AtomicReference();
                entryType.accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitSimpleType(SimpleType simpleType) {
                        mapResult.set(((Collection)v).stream().collect(Collectors.toMap(item -> item.getParameter("General", "key").getValue().getRight(), item -> MuleAstUtils.createComponentParameterizationFromComponentAstParameter(item.getParameter("General", "value").getValue(), entryType).orElse(null))));
                    }

                    @Override
                    protected void defaultVisit(MetadataType metadataType) {
                        mapResult.set(((Collection)v).stream().collect(Collectors.toMap(item -> item.getParameter("General", "key").getValue().getRight(), MuleAstUtils::createComponentParameterizationFromComponentAst)));
                    }
                });
                result = mapResult.get();
            } else {
                ArrayType arrayType = (ArrayType)metadataType;
                final MetadataType itemsType = arrayType.getType();
                final AtomicReference arrayResult = new AtomicReference();
                itemsType.accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitSimpleType(SimpleType simpleType) {
                        arrayResult.set(((Collection)v).stream().map(item -> MuleAstUtils.createComponentParameterizationFromComponentAstParameter(item.getParameter("General", "value").getValue(), itemsType).orElse(null)).collect(Collectors.toList()));
                    }

                    @Override
                    protected void defaultVisit(MetadataType metadataType) {
                        arrayResult.set(((Collection)v).stream().map(MuleAstUtils::createComponentParameterizationFromComponentAst).collect(Collectors.toList()));
                    }
                });
                result = arrayResult.get();
            }
        }
        return result;
    }

    @Deprecated
    public static ValidationResult validate(ArtifactAst artifact) {
        return MuleAstUtils.validate(artifact, v -> {}, v -> true, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public static ValidationResult validate(ArtifactAst artifact, Consumer<ValidationsProvider> validationEnricher) {
        return MuleAstUtils.validate(artifact, validationEnricher, v -> true, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public static ValidationResult validate(ArtifactAst artifact, Predicate<Validation> validationsFilter) {
        return MuleAstUtils.validate(artifact, v -> {}, validationsFilter, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public static ValidationResult validate(ArtifactAst artifact, Consumer<ValidationsProvider> validationEnricher, Predicate<Validation> validationsFilter, ClassLoader artifactRegionClassLoader) {
        return MuleAstUtils.validatorBuilder().withValidationEnricher(validationEnricher).withValidationsFilter(validationsFilter).withArtifactRegionClassLoader(artifactRegionClassLoader).build().validate(artifact);
    }

    public static ArtifactAst filteredArtifactAst(ArtifactAst artifactAst, Predicate<ComponentAst> componentFilter) {
        return new FilteredArtifactAst(artifactAst, componentFilter);
    }

    public static boolean areComponentsEquals(ComponentAst compA, ComponentAst compB) {
        if (!Objects.equals(compA.getIdentifier(), compB.getIdentifier())) {
            return false;
        }
        if (compA.getModel(Object.class).orElse(null) != compB.getModel(Object.class).orElse(null)) {
            return false;
        }
        if (compA.getParameters().size() != compB.getParameters().size()) {
            return false;
        }
        if (compA.directChildren().size() != compB.directChildren().size()) {
            return false;
        }
        for (ComponentParameterAst paramA : compA.getParameters()) {
            ComponentParameterAst paramB = compB.getParameter(paramA.getGroupModel().getName(), paramA.getModel().getName());
            if (paramB == null) {
                return false;
            }
            if (MuleAstUtils.areParametersEquals(paramA, paramB)) continue;
            return false;
        }
        Iterator<ComponentAst> childrenIteratorB = compB.directChildren().iterator();
        for (ComponentAst childA : compA.directChildren()) {
            ComponentAst childB;
            if (MuleAstUtils.areComponentsEquals(childA, childB = childrenIteratorB.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean areParametersEquals(ComponentParameterAst paramA, ComponentParameterAst paramB) {
        if (paramA.getValue() == null && paramB.getValue() == null) {
            return true;
        }
        if (paramA.getValue() != null && paramB.getValue() != null) {
            if (paramA.getValue().getValue().isPresent()) {
                if (!paramB.getValue().getValue().isPresent()) {
                    return false;
                }
                return paramA.getValue().reduce(exprA -> paramB.getValue().isLeft() && exprA.equals(paramB.getValue().getLeft()), fixedValueA -> {
                    if (!paramB.getValue().isRight()) {
                        return false;
                    }
                    return MuleAstUtils.areParametersValuesEquals(fixedValueA, paramB.getValue().getRight());
                });
            }
            return !paramB.getValue().getValue().isPresent();
        }
        return false;
    }

    private static boolean areParametersValuesEquals(Object valueA, Object valueB) {
        if (valueA instanceof ComponentAst) {
            if (!(valueB instanceof ComponentAst)) {
                return false;
            }
            return MuleAstUtils.areComponentsEquals((ComponentAst)valueA, (ComponentAst)valueB);
        }
        if (valueA instanceof Collection) {
            if (!(valueB instanceof Collection)) {
                return false;
            }
            if (((Collection)valueA).size() != ((Collection)valueB).size()) {
                return false;
            }
            Iterator childrenIteratorB = ((Collection)valueB).iterator();
            for (Object childA : (Collection)valueA) {
                Object childB;
                if (MuleAstUtils.areParametersValuesEquals(childA, childB = childrenIteratorB.next())) continue;
                return false;
            }
        }
        return valueA.equals(valueB);
    }
}

