/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.bean;

import jakarta.inject.Inject;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.config.api.bean.ObjectSerializerDelegate;
import org.mule.runtime.core.api.MuleContext;

public class DefaultObjectSerializerDelegate
implements ObjectSerializerDelegate {
    private ReadWriteLock delegateLock = new ReentrantReadWriteLock();
    private volatile ObjectSerializer delegate;

    @Override
    public SerializationProtocol getInternalProtocol() {
        return this.getDelegate().getInternalProtocol();
    }

    @Override
    public SerializationProtocol getExternalProtocol() {
        return this.getDelegate().getExternalProtocol();
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.setDelegate(muleContext.getObjectSerializer());
    }

    @Override
    public void setDelegate(ObjectSerializer delegate) {
        this.delegateLock.writeLock().lock();
        try {
            this.delegate = delegate;
        }
        finally {
            this.delegateLock.writeLock().unlock();
        }
    }

    @Override
    public ObjectSerializer getDelegate() {
        this.delegateLock.readLock().lock();
        try {
            ObjectSerializer objectSerializer = this.delegate;
            return objectSerializer;
        }
        finally {
            this.delegateLock.readLock().unlock();
        }
    }
}

