/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;

public class CachingComponentBuildingDefinitionRegistryFactory
implements ComponentBuildingDefinitionRegistryFactory {
    private final Map<ComponentBuildingDefinitionRegistryCacheKey, ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistryCache = new HashMap<ComponentBuildingDefinitionRegistryCacheKey, ComponentBuildingDefinitionRegistry>();

    @Override
    public ComponentBuildingDefinitionRegistry create(Set<ExtensionModel> extensionModels, Function<ExtensionModel, Optional<DslSyntaxResolver>> dslSyntaxResolverLookup) {
        return this.componentBuildingDefinitionRegistryCache.computeIfAbsent(new ComponentBuildingDefinitionRegistryCacheKey(extensionModels, Boolean.getBoolean("mule.experimental.enableDynamicConfigRef"), Boolean.getBoolean("ocs.enabled")), key -> this.createComponentBuildingDefinitionRegistry(key.getExtensions(), dslSyntaxResolverLookup));
    }

    public ComponentBuildingDefinitionRegistry createComponentBuildingDefinitionRegistry(Set<ExtensionModel> extModels, Function<ExtensionModel, Optional<DslSyntaxResolver>> dslSyntaxResolverLookup) {
        Map extModelsDsls = extModels.stream().filter(ext -> ((Optional)dslSyntaxResolverLookup.apply((ExtensionModel)ext)).isPresent()).collect(Collectors.toMap(UnaryOperator.identity(), ext -> (DslSyntaxResolver)((Optional)dslSyntaxResolverLookup.apply((ExtensionModel)ext)).orElseThrow()));
        return DEFAULT_FACTORY.create(extModels, extModel -> Optional.ofNullable((DslSyntaxResolver)extModelsDsls.get(extModel)));
    }

    private class ComponentBuildingDefinitionRegistryCacheKey {
        private Set<ExtensionModel> extensions;
        private boolean dynamiConfigsEnabled;
        private boolean ocsEnabled;

        public ComponentBuildingDefinitionRegistryCacheKey(Set<ExtensionModel> extensions, boolean dynamiConfigsEnabled, boolean ocsEnabled) {
            this.extensions = extensions;
            this.dynamiConfigsEnabled = dynamiConfigsEnabled;
        }

        public Set<ExtensionModel> getExtensions() {
            return this.extensions;
        }

        public boolean isDynamiConfigsEnabled() {
            return this.dynamiConfigsEnabled;
        }

        public boolean isOcsEnabled() {
            return this.ocsEnabled;
        }

        public int hashCode() {
            return Objects.hash(this.dynamiConfigsEnabled, this.extensions, this.ocsEnabled);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentBuildingDefinitionRegistryCacheKey other = (ComponentBuildingDefinitionRegistryCacheKey)obj;
            return this.dynamiConfigsEnabled == other.dynamiConfigsEnabled && this.ocsEnabled == other.ocsEnabled && Objects.equals(this.extensions, other.extensions);
        }
    }
}

