/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.serialization.SerializationProtocol;

public abstract class AbstractSerializationProtocol
implements SerializationProtocol {
    protected abstract byte[] doSerialize(Object var1) throws Exception;

    protected abstract <T> T doDeserialize(InputStream var1, ClassLoader var2) throws Exception;

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        try {
            return this.doSerialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize object", (Throwable)e);
        }
    }

    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        try {
            byte[] bytes = this.serialize(object);
            out.write(bytes);
            out.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not write to output stream", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) throws SerializationException {
        return this.deserialize(bytes, this.getExecutionClassLoader());
    }

    @Override
    public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
        Objects.requireNonNull(bytes, "The byte[] must not be null");
        return this.deserialize(new ByteArrayInputStream(bytes), classLoader);
    }

    @Override
    public <T> T deserialize(InputStream inputStream) throws SerializationException {
        return this.deserialize(inputStream, this.getExecutionClassLoader());
    }

    @Override
    public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
        Objects.requireNonNull(inputStream, "Cannot deserialize a null stream");
        Objects.requireNonNull(classLoader, "Cannot deserialize with a null classloader");
        try {
            T t = this.doDeserialize(inputStream, classLoader);
            return t;
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize object", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    protected abstract ClassLoader getExecutionClassLoader();
}

