/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.util.Objects;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.server.DefaultPathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;

public class PathAndMethodRequestMatcherBuilder {
    private String path;
    private MethodRequestMatcher methodRequestMatcher = MethodRequestMatcher.acceptAll();

    PathAndMethodRequestMatcherBuilder() {
    }

    public PathAndMethodRequestMatcherBuilder methodRequestMatcher(MethodRequestMatcher methodRequestMatcher) {
        Objects.requireNonNull(methodRequestMatcher, "method matcher cannot be null");
        this.methodRequestMatcher = methodRequestMatcher;
        return this;
    }

    public PathAndMethodRequestMatcherBuilder path(String path) {
        Preconditions.checkArgument(this.nonEmpty(path), "path cannot be empty nor null");
        this.path = path;
        return this;
    }

    private boolean nonEmpty(String path) {
        return path != null && !"".equals(path.trim());
    }

    public PathAndMethodRequestMatcher build() {
        return new DefaultPathAndMethodRequestMatcher(this.methodRequestMatcher, this.path);
    }
}

