/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.streaming.CursorResetHandler;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class CursorResetInterceptor
implements Interceptor<OperationModel> {
    public static final String CURSOR_RESET_HANDLER_VARIABLE = "CURSOR_RESET_HANDLER";
    private final Map<ParameterGroupModel, Set<ParameterModel>> cursorParametersMap;
    private final ReflectionCache reflectionCache;

    public CursorResetInterceptor(Map<ParameterGroupModel, Set<ParameterModel>> cursorParametersMap, ReflectionCache reflectionCache) {
        this.cursorParametersMap = cursorParametersMap;
        this.reflectionCache = reflectionCache;
    }

    @Override
    public void before(ExecutionContext<OperationModel> ctx) throws Exception {
        List<Cursor> cursors = this.getParameterCursors(ctx);
        if (!cursors.isEmpty()) {
            ((ExecutionContextAdapter)ctx).setVariable(CURSOR_RESET_HANDLER_VARIABLE, new CursorResetHandler(cursors));
        }
    }

    @Override
    public Throwable onError(ExecutionContext<OperationModel> executionContext, Throwable exception) {
        ExceptionUtils.extractConnectionException(exception).ifPresent(cne -> {
            CursorResetHandler cursorResetHandler = (CursorResetHandler)((ExecutionContextAdapter)executionContext).removeVariable(CURSOR_RESET_HANDLER_VARIABLE);
            if (cursorResetHandler != null) {
                cursorResetHandler.resetCursors();
            }
        });
        return exception;
    }

    private List<Cursor> getParameterCursors(ExecutionContext<OperationModel> ctx) {
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        this.cursorParametersMap.forEach((parameterGroupModel, parameterModels) -> parameterModels.forEach(parameterModel -> {
            Object value = this.getParameterValue(ctx, (ParameterGroupModel)parameterGroupModel, (ParameterModel)parameterModel);
            if (value instanceof Cursor) {
                cursors.add((Cursor)value);
            }
        }));
        return cursors;
    }

    private Object getParameterValue(ExecutionContext<OperationModel> ctx, ParameterGroupModel parameterGroupModel, ParameterModel parameterModel) {
        Object value = IntrospectionUtils.getParameterOrDefault(ctx, parameterGroupModel, parameterModel, null, this.reflectionCache);
        if (value instanceof TypedValue) {
            value = ((TypedValue)value).getValue();
        }
        return value;
    }
}

