/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.producer;

import java.util.function.Function;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

public class ComponentProcessingStrategyProfilingDataProducer
implements ResettableProfilingDataProducer<DefaultComponentProcessingStrategyProfilingEventContext, CoreEvent> {
    private final DefaultProfilingService defaultProfilingService;
    private final ProfilingEventType<ComponentProcessingStrategyProfilingEventContext> profilingEventType;
    private final ProfilingDataProducerStatus profilingProducerStatus;

    public ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService defaultProfilingService, ProfilingEventType<ComponentProcessingStrategyProfilingEventContext> profilingEventType, ProfilingProducerScope profilingProducerScope, ProfilingFeatureFlaggingService featureFlaggingService) {
        this.defaultProfilingService = defaultProfilingService;
        this.profilingEventType = profilingEventType;
        this.profilingProducerStatus = featureFlaggingService.getProfilingDataProducerStatus(profilingEventType, profilingProducerScope);
    }

    @Override
    public void triggerProfilingEvent(DefaultComponentProcessingStrategyProfilingEventContext profilingEventContext) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent(profilingEventContext, this.profilingEventType);
        }
    }

    @Override
    public void triggerProfilingEvent(CoreEvent sourceData, Function<CoreEvent, DefaultComponentProcessingStrategyProfilingEventContext> transformation) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent((ComponentProcessingStrategyProfilingEventContext)transformation.apply(sourceData), this.profilingEventType);
        }
    }

    @Override
    public void reset() {
        this.profilingProducerStatus.reset();
    }
}

