/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAlias;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.AbstractJavaParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.HasExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.param.display.DisplayName;

public class JavaDeclaredParameterGroupModelParser
extends AbstractJavaParameterGroupModelParser
implements HasExtensionParameter {
    private final List<ExtensionParameter> parameters;
    private final ExtensionParameter groupParameter;
    private final Type type;
    private final String groupName;
    private java.util.Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> exclusiveOptionalDescriptor;

    public JavaDeclaredParameterGroupModelParser(ExtensionParameter groupParameter, ParameterDeclarationContext context, Function<ParameterModelParser, ParameterModelParser> parameterMutator) {
        super(context, parameterMutator);
        this.groupParameter = groupParameter;
        this.type = groupParameter.getType();
        this.groupName = this.fetchGroupName();
        this.parameters = this.fetchAnnotatedParameter();
        this.assureValid(groupParameter, context);
        this.parseStructure();
    }

    private void parseStructure() {
        this.parseExclusiveOptionalDescriptor();
    }

    @Override
    public String getName() {
        return this.groupName;
    }

    @Override
    public String getDescription() {
        return this.groupParameter.getDescription();
    }

    @Override
    protected Stream<ExtensionParameter> doGetParameters() {
        return this.parameters.stream();
    }

    @Override
    public java.util.Optional<DisplayModel> getDisplayModel() {
        return MuleExtensionAnnotationParser.mapReduceAnnotation(this.groupParameter, org.mule.runtime.extension.api.annotation.param.display.DisplayName.class, DisplayName.class, legacyAnnotationValueFetcher -> this.buildDisplayModel(legacyAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.param.display.DisplayName::value)), sdkAnnotationValueFetcher -> this.buildDisplayModel(sdkAnnotationValueFetcher.getStringValue(DisplayName::value)), () -> new IllegalParameterModelDefinitionException(String.format("ParameterGroup '%s' is annotated with '@%s' and '@%s' at the same time", this.getName(), org.mule.runtime.extension.api.annotation.param.display.DisplayName.class.getName(), DisplayName.class.getName())));
    }

    @Override
    public java.util.Optional<LayoutModel> getLayoutModel() {
        return MuleExtensionAnnotationParser.parseLayoutAnnotations(this.groupParameter, LayoutModel.builder(), this.groupParameter.getName());
    }

    @Override
    public java.util.Optional<ParameterGroupModelParser.ExclusiveOptionalDescriptor> getExclusiveOptionals() {
        return this.exclusiveOptionalDescriptor;
    }

    @Override
    public boolean showsInDsl() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.groupParameter, "parameter group", "", org.mule.runtime.extension.api.annotation.param.ParameterGroup.class, ParameterGroup.class, value -> value.getBooleanValue(org.mule.runtime.extension.api.annotation.param.ParameterGroup::showInDsl), value -> value.getBooleanValue(ParameterGroup::showInDsl)).orElse(false);
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        LinkedList<ModelProperty> properties = new LinkedList<ModelProperty>();
        properties.add(new ParameterGroupModelProperty(new ParameterGroupDescriptor(this.groupName, this.type, this.groupParameter.getType().asMetadataType(), this.groupParameter.getDeclaringElement().orElse(null), this.groupParameter)));
        properties.add(new ExtensionParameterDescriptorModelProperty(this.groupParameter));
        return properties;
    }

    private void assureValid(ExtensionParameter groupParameter, ParameterDeclarationContext context) {
        if ("General".equals(this.groupName)) {
            throw new IllegalParameterModelDefinitionException(String.format("%s '%s' defines parameter group of name '%s' which is the default one. @%s cannot be used with the default group name", context.getComponentType(), context.getComponentName(), this.groupName, org.mule.runtime.extension.api.annotation.param.ParameterGroup.class.getSimpleName()));
        }
        List<FieldElement> nestedGroups = this.type.getAnnotatedFields(org.mule.runtime.extension.api.annotation.param.ParameterGroup.class, ParameterGroup.class);
        if (!nestedGroups.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Class '%s' is used as a @%s but contains fields which also hold that annotation. Nesting groups is not allowed. Offending fields are: [%s]", this.type.getName(), org.mule.runtime.extension.api.annotation.param.ParameterGroup.class.getSimpleName(), nestedGroups.stream().map(element -> element.getName()).collect(Collectors.joining(","))));
        }
        if (groupParameter.isAnnotatedWith(org.mule.runtime.extension.api.annotation.param.Optional.class)) {
            throw new IllegalParameterModelDefinitionException(String.format("@%s can not be applied alongside with @%s. Affected parameter is [%s].", org.mule.runtime.extension.api.annotation.param.Optional.class.getSimpleName(), org.mule.runtime.extension.api.annotation.param.ParameterGroup.class.getSimpleName(), groupParameter.getName()));
        }
        if (groupParameter.isAnnotatedWith(Optional.class)) {
            throw new IllegalParameterModelDefinitionException(String.format("@%s can not be applied alongside with @%s. Affected parameter is [%s].", Optional.class.getSimpleName(), org.mule.runtime.extension.api.annotation.param.ParameterGroup.class.getSimpleName(), groupParameter.getName()));
        }
    }

    private String fetchGroupName() {
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.groupParameter, "parameter group", "", org.mule.runtime.extension.api.annotation.param.ParameterGroup.class, ParameterGroup.class, value -> value.getStringValue(org.mule.runtime.extension.api.annotation.param.ParameterGroup::name), value -> value.getStringValue(ParameterGroup::name)).orElse("General");
    }

    private DisplayModel buildDisplayModel(String displayName) {
        return DisplayModel.builder().displayName(displayName).build();
    }

    private List<ExtensionParameter> fetchAnnotatedParameter() {
        List<ExtensionParameter> parameters = this.type.getAnnotatedFields(org.mule.runtime.extension.api.annotation.param.Parameter.class, Parameter.class);
        if (parameters.isEmpty()) {
            parameters = IntrospectionUtils.getFieldsWithGetters(this.type);
        }
        return parameters;
    }

    private void parseExclusiveOptionalDescriptor() {
        java.util.Optional<Boolean> exclusiveOptionalsIsOneRequired = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.type, "parameter", "", ExclusiveOptionals.class, org.mule.sdk.api.annotation.param.ExclusiveOptionals.class, value -> value.getBooleanValue(ExclusiveOptionals::isOneRequired), value -> value.getBooleanValue(org.mule.sdk.api.annotation.param.ExclusiveOptionals::isOneRequired));
        this.exclusiveOptionalDescriptor = exclusiveOptionalsIsOneRequired.map(isOneRequired -> new ParameterGroupModelParser.ExclusiveOptionalDescriptor(this.parameters.stream().filter(f -> !f.isRequired()).map(WithAlias::getAlias).collect(Collectors.toSet()), (boolean)isOneRequired));
    }

    @Override
    public ExtensionParameter getExtensionParameter() {
        return this.groupParameter;
    }
}

