/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
public abstract class MuleDeployableModel
extends AbstractMuleArtifactModel {
    private Set<String> configs;
    private List<String> secureProperties;
    private Set<String> supportedJavaVersions;
    private Boolean redeploymentEnabled = true;
    private String logConfigFile;

    protected MuleDeployableModel() {
    }

    protected MuleDeployableModel(String name, String minMuleVersion, Product product, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptorLoader, Set<String> configs, Optional<Boolean> redeploymentEnabled, List<String> secureProperties, Set<String> supportedJavaVersions, String logConfigFile) {
        super(name, minMuleVersion, product, classLoaderModelLoaderDescriptor, bundleDescriptorLoader);
        this.configs = configs;
        this.redeploymentEnabled = redeploymentEnabled.orElse(true);
        this.secureProperties = secureProperties;
        this.supportedJavaVersions = supportedJavaVersions;
        this.logConfigFile = logConfigFile;
    }

    public Set<String> getConfigs() {
        return this.configs == null ? null : Collections.unmodifiableSet(this.configs);
    }

    public boolean isRedeploymentEnabled() {
        return this.redeploymentEnabled == null ? true : this.redeploymentEnabled;
    }

    public List<String> getSecureProperties() {
        return this.secureProperties;
    }

    public Set<String> getSupportedJavaVersions() {
        return this.supportedJavaVersions == null ? Collections.emptySet() : Collections.unmodifiableSet(this.supportedJavaVersions);
    }

    public String getLogConfigFile() {
        return this.logConfigFile;
    }

    protected static abstract class MuleDeployableModelBuilder<T extends AbstractMuleArtifactModelBuilder, M extends MuleDeployableModel>
    extends AbstractMuleArtifactModelBuilder<T, M> {
        private Set<String> configs = new HashSet<String>();
        private Boolean redeploymentEnabled;
        private List<String> secureProperties = new ArrayList<String>();
        private Set<String> supportedJavaVersions = Collections.emptySet();
        private String logConfigFile;

        protected MuleDeployableModelBuilder() {
        }

        public void setConfigs(Set<String> configs) {
            this.configs = configs;
        }

        @Override
        public final M build() {
            Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return this.doCreateModel(this.configs, this.redeploymentEnabled, this.secureProperties, this.supportedJavaVersions, this.logConfigFile);
        }

        protected abstract M doCreateModel(Set<String> var1, Boolean var2, List<String> var3, Set<String> var4, String var5);

        public void setRedeploymentEnabled(boolean redeploymentEnabled) {
            this.redeploymentEnabled = redeploymentEnabled;
        }

        public void setSecureProperties(List<String> secureProperties) {
            this.secureProperties = secureProperties;
        }

        public void setSupportedJavaVersions(Set<String> supportedJavaVersions) {
            this.supportedJavaVersions = Objects.requireNonNull(supportedJavaVersions);
        }

        public void setLogConfigFile(String logConfigFile) {
            this.logConfigFile = logConfigFile;
        }
    }
}

