/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.exception.MessagingExceptionResolver;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.exception.MessagingException;

public final class ChainErrorHandlingUtils {
    private ChainErrorHandlingUtils() {
    }

    public static BiFunction<Throwable, Object, Throwable> getLocalOperatorErrorHook(Processor processor, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders) {
        MessagingExceptionResolver messagingExceptionResolver;
        if (processor instanceof Component) {
            Component component = (Component)((Object)processor);
            messagingExceptionResolver = new MessagingExceptionResolver(component);
        } else {
            messagingExceptionResolver = null;
        }
        MessagingExceptionResolver exceptionResolver = messagingExceptionResolver;
        UnaryOperator<MessagingException> messagingExceptionMapper = ChainErrorHandlingUtils.resolveMessagingException(processor, e -> exceptionResolver.resolve((MessagingException)e, locator, exceptionContextProviders));
        return (throwable, event) -> {
            throwable = Exceptions.unwrap(throwable);
            if (event instanceof CoreEvent) {
                CoreEvent coreEvent = (CoreEvent)event;
                if (throwable instanceof MessagingException) {
                    MessagingException msgException = (MessagingException)throwable;
                    return (Throwable)messagingExceptionMapper.apply(msgException);
                }
                return ChainErrorHandlingUtils.resolveException(processor, coreEvent, throwable, locator, exceptionContextProviders, exceptionResolver);
            }
            return throwable;
        };
    }

    static MessagingException resolveException(Processor processor, CoreEvent event, Throwable throwable, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders, MessagingExceptionResolver exceptionResolver) {
        if (event.getError().isPresent()) {
            event = CoreEvent.builder(event).error(null).build();
        }
        if (processor instanceof Component) {
            Component component = (Component)((Object)processor);
            return exceptionResolver.resolve(new MessagingException(event, throwable, component), locator, exceptionContextProviders);
        }
        return new MessagingException(event, throwable);
    }

    static UnaryOperator<MessagingException> resolveMessagingException(Processor processor, UnaryOperator<MessagingException> messagingExceptionMapper) {
        if (processor instanceof Component) {
            return exception -> {
                if (!exception.getEvent().getError().isPresent() || exception.getCause() instanceof RetryPolicyExhaustedException || exception.getCause() instanceof ComposedErrorException) {
                    return (MessagingException)messagingExceptionMapper.apply((MessagingException)exception);
                }
                return exception;
            };
        }
        return UnaryOperator.identity();
    }

    static Error resolveError(EventProcessingException exception, ErrorTypeLocator errorTypeLocator) {
        ErrorType errorType = Optional.ofNullable(exception.getExceptionInfo().getErrorType()).orElse(errorTypeLocator.lookupErrorType(ExceptionHelper.getRootMuleException(exception)));
        return exception.getEvent().getError().orElseGet(() -> ErrorBuilder.builder().exception(exception).description(exception.getMessage()).detailedDescription(exception.getDetailedMessage()).errorType(errorType).failingComponent(exception.getFailingComponent()).build());
    }
}

