/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.Collection;
import java.util.Collections;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.module.extension.internal.metadata.DsqlQueryMetadataResolver;

public final class QueryMetadataResolverFactory
implements MetadataResolverFactory {
    private final OutputTypeResolver outputTypeResolver;
    private final QueryEntityResolver queryMetadataEntityResolver;
    private final NullMetadataResolver nullMetadataResolver = new NullMetadataResolver();

    public QueryMetadataResolverFactory(Class<? extends OutputTypeResolver> outputResolver, Class<? extends QueryEntityResolver> queryEntityResolver) {
        Preconditions.checkArgument(outputResolver != null, "OutputTypeResolver type cannot be null");
        Preconditions.checkArgument(queryEntityResolver != null, "QueryEntityResolver type cannot be null");
        this.outputTypeResolver = (OutputTypeResolver)this.instantiateResolver(outputResolver);
        this.queryMetadataEntityResolver = (QueryEntityResolver)this.instantiateResolver(queryEntityResolver);
    }

    @Override
    public TypeKeysResolver getKeyResolver() {
        return this.nullMetadataResolver;
    }

    @Override
    public <T> InputTypeResolver<T> getInputResolver(String parameterName) {
        return this.nullMetadataResolver;
    }

    @Override
    public Collection<InputTypeResolver> getInputResolvers() {
        return Collections.emptyList();
    }

    @Override
    public <T> AttributesTypeResolver<T> getOutputAttributesResolver() {
        return this.nullMetadataResolver;
    }

    @Override
    public <T> OutputTypeResolver<T> getOutputResolver() {
        return new DsqlQueryMetadataResolver(this.queryMetadataEntityResolver, this.outputTypeResolver);
    }

    @Override
    public QueryEntityResolver getQueryEntityResolver() {
        return this.queryMetadataEntityResolver;
    }

    private <T> T instantiateResolver(Class<?> factoryType) {
        try {
            return (T)factoryType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create NamedTypeResolver of type " + factoryType.getName()), (Throwable)e);
        }
    }
}

