/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.customization.impl.export;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.customization.api.InitialExportInfoProvider;
import org.mule.runtime.tracer.customization.impl.export.NoExportTillSpanWithNameInitialExportInfo;
import org.mule.runtime.tracer.customization.impl.info.SpanInitialInfoUtils;

public abstract class AbstractInitialExportInfoProvider
implements InitialExportInfoProvider {
    private final Map<Class, InitialExportInfo> initialExportInfoMapByComponentClass = new HashMap<Class, InitialExportInfo>(){
        {
            this.put(PolicyChain.class, new NoExportTillSpanWithNameInitialExportInfo("execute-next", true));
        }
    };

    @Override
    public InitialExportInfo getInitialExportInfo(Component component) {
        return this.getInitialExportInfo(component, "");
    }

    @Override
    public InitialExportInfo getInitialExportInfo(Component component, String spanNameSuffix) {
        InitialExportInfo initialExportInfo = this.initialExportInfoMapByComponentClass.get(component.getClass());
        if (initialExportInfo != null) {
            return initialExportInfo;
        }
        return this.doGetInitialExportInfo(SpanInitialInfoUtils.getSpanName(component.getIdentifier()) + StringUtils.stripToEmpty((String)spanNameSuffix));
    }

    @Override
    public InitialExportInfo getInitialExportInfo(String spanName) {
        return this.getInitialExportInfo(spanName, false);
    }

    @Override
    public InitialExportInfo getInitialExportInfo(String spanName, boolean debugLevel) {
        if (debugLevel) {
            return this.doGetInitialExportInfoForDebugLevel();
        }
        return this.doGetInitialExportInfo(spanName);
    }

    protected abstract InitialExportInfo doGetInitialExportInfoForDebugLevel();

    private InitialExportInfo doGetInitialExportInfo(String componentFullyQualifiedName) {
        InitialExportInfo initialExportInfo = this.getInitialExportInfoMapByName().get(componentFullyQualifiedName);
        if (initialExportInfo == null) {
            initialExportInfo = this.getDefaultInitialExportInfo();
        }
        return initialExportInfo;
    }

    protected abstract InitialExportInfo getDefaultInitialExportInfo();

    protected abstract Map<String, InitialExportInfo> getInitialExportInfoMapByName();
}

