/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.config.internal.bean.DefaultObjectSerializerDelegate;
import org.mule.runtime.config.internal.bean.MuleConfigurationDelegate;
import org.mule.runtime.config.internal.context.AbstractSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.el.DataWeaveExtendedExpressionLanguageAdaptorFactoryBean;
import org.mule.runtime.config.internal.el.DefaultExpressionManagerFactoryBean;
import org.mule.runtime.config.internal.factories.SchedulerBaseConfigFactory;
import org.mule.runtime.config.internal.lazy.LazyDataWeaveExtendedExpressionLanguageAdaptorFactoryBean;
import org.mule.runtime.config.internal.registry.SpringRegistryBootstrap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.alert.DefaultAlertingSupport;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.core.internal.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transformer.DefaultTransformersRegistry;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BaseSpringMuleContextServiceConfigurator
extends AbstractSpringMuleContextServiceConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSpringMuleContextServiceConfigurator.class);
    @Deprecated
    public static final String DISABLE_TRANSFORMERS_SUPPORT = BaseSpringMuleContextServiceConfigurator.class.getName() + ".disableTransformersSupport";
    private final Map<String, BeanDefinition> baseContextServices = Map.ofEntries(Map.entry("_muleTimeSupplier", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(LocalTimeSupplier.class)), Map.entry("_muleAlertingSupport", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultAlertingSupport.class)));
    private final MuleContext muleContext;
    private final ArtifactType artifactType;
    private final ConfigurationProperties configurationProperties;
    private final boolean enableLazyInit;
    private Registry originalRegistry;

    public BaseSpringMuleContextServiceConfigurator(MuleContext muleContext, ConfigurationProperties configurationProperties, ArtifactType artifactType, BeanDefinitionRegistry beanDefinitionRegistry, org.mule.runtime.api.artifact.Registry serviceLocator, Registry originalRegistry, boolean enableLazyInit) {
        super((InternalCustomizationService)muleContext.getCustomizationService(), beanDefinitionRegistry, serviceLocator);
        this.muleContext = muleContext;
        this.configurationProperties = configurationProperties;
        this.artifactType = artifactType;
        this.originalRegistry = originalRegistry;
        this.enableLazyInit = enableLazyInit;
    }

    void createArtifactServices() {
        FeatureFlaggingService featureFlaggingService = (FeatureFlaggingService)this.originalRegistry.lookupObject("core.featureFlaggingService");
        this.registerConstantBeanDefinition("core.featureFlaggingService", featureFlaggingService);
        this.registerConstantBeanDefinition("_muleArtifactEncoding", this.originalRegistry.lookupObject("_muleArtifactEncoding"));
        this.registerConstantBeanDefinition("_muleConfigurationComponentLocator", new BaseConfigurationComponentLocator());
        if (!this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            this.loadServiceConfigurators();
        }
        this.registerContextServices(this.baseContextServices, this.artifactType.equals((Object)ArtifactType.DOMAIN));
        ContributedErrorTypeRepository contributedErrorTypeRepository = new ContributedErrorTypeRepository();
        this.registerConstantBeanDefinition(ErrorTypeRepository.class.getName(), contributedErrorTypeRepository);
        ContributedErrorTypeLocator contributedErrorTypeLocator = new ContributedErrorTypeLocator();
        contributedErrorTypeLocator.setDelegate(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(contributedErrorTypeRepository, Optional.of(featureFlaggingService)));
        this.registerConstantBeanDefinition(ErrorTypeLocator.class.getName(), contributedErrorTypeLocator);
        this.registerConstantBeanDefinition("_muleConfigurationAttributesResolver", this.configurationProperties);
        if (!Boolean.getBoolean(DISABLE_TRANSFORMERS_SUPPORT)) {
            this.registerBeanDefinition("_muleTransfromerResolver", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(TypeBasedTransformerResolver.class));
            this.registerBeanDefinition("_muleTransfromersRegistry", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultTransformersRegistry.class));
        }
        this.registerLazyInitialisationAwareBeans();
        this.registerBeanDefinition("_muleExpressionManager", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultExpressionManagerFactoryBean.class));
        this.registerBeanDefinition("_muleSchedulerPoolsConfig", BaseSpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(SchedulerContainerPoolsConfig.getInstance()));
        this.registerBeanDefinition("_muleSchedulerBaseConfig", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(SchedulerBaseConfigFactory.class));
        this.registerConstantBeanDefinition("_muleRegistry", this.getServiceLocator());
        this.registerBeanDefinition("_muleDefaultObjectSerializer", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectSerializerDelegate.class));
        this.registerBeanDefinition("_muleConfiguration", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(MuleConfigurationDelegate.class));
        this.createRuntimeServices();
        this.createBootstrapBeanDefinitions();
        this.absorbOriginalRegistry();
    }

    private void registerLazyInitialisationAwareBeans() {
        if (this.enableLazyInit) {
            this.registerBeanDefinition("_muleDwExpressionLanguageAdapter", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(LazyDataWeaveExtendedExpressionLanguageAdaptorFactoryBean.class));
        } else {
            this.registerBeanDefinition("_muleDwExpressionLanguageAdapter", BaseSpringMuleContextServiceConfigurator.getBeanDefinition(DataWeaveExtendedExpressionLanguageAdaptorFactoryBean.class));
        }
    }

    protected void createBootstrapBeanDefinitions() {
        try {
            SpringRegistryBootstrap springRegistryBootstrap = new SpringRegistryBootstrap(this.artifactType, this.muleContext.getRegistryBootstrapServiceDiscoverer(), this::registerBeanDefinition, AbstractRegistryBootstrap.BINDING_PROVIDER_PREDICATE.or(AbstractRegistryBootstrap.TRANSFORMER_PREDICATE));
            springRegistryBootstrap.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
    }

    private void createRuntimeServices() {
        Map<String, CustomService> customServices = this.getCustomizationService().getCustomServices();
        for (String serviceName : customServices.keySet()) {
            if (this.containsBeanDefinition(serviceName)) {
                throw new IllegalStateException("There is already a bean definition registered with key: " + serviceName);
            }
            CustomService customService = customServices.get(serviceName);
            if (!customService.isBaseContext() && !this.isServiceRuntimeProvided(customService)) continue;
            BeanDefinition beanDefinition = this.getCustomServiceBeanDefinition(customService, serviceName);
            LOGGER.debug("Registering runtime service '{}' for {}...", (Object)serviceName, (Object)this.artifactType.name());
            this.registerBeanDefinition(serviceName, beanDefinition);
        }
    }

    private void absorbOriginalRegistry() {
        if (this.originalRegistry == null) {
            return;
        }
        this.originalRegistry.lookupByType(Object.class).forEach(this::registerConstantBeanDefinition);
        this.originalRegistry = null;
    }
}

