/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.runtime.core.internal.context.ArtifactStoppedPersistenceListener;
import org.mule.runtime.core.internal.context.FlowStoppedPersistenceListener;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.mule.runtime.module.deployment.internal.ArtifactDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactStoppedDeploymentPersistenceListener;
import org.mule.runtime.module.deployment.internal.FlowStoppedDeploymentPersistenceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactDeployer<T extends DeployableArtifact>
implements ArtifactDeployer<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultArtifactDeployer.class);
    private final Map<String, List<FlowStoppedPersistenceListener>> appsFlowStoppedListeners = new ConcurrentHashMap<String, List<FlowStoppedPersistenceListener>>();
    private final Supplier<Scheduler> artifactStartExecutor;

    public DefaultArtifactDeployer(Supplier<Scheduler> artifactStartExecutor) {
        this.artifactStartExecutor = artifactStartExecutor;
    }

    @Override
    public void deploy(T artifact, boolean startArtifact) {
        try {
            artifact.install();
            this.doInit(artifact);
            this.addFlowStoppedListeners(artifact);
            if (startArtifact && this.shouldStartArtifactAccordingToPersistedStatus(artifact).booleanValue()) {
                Future<?> startTask = this.artifactStartExecutor.get().submit(() -> {
                    try {
                        artifact.start();
                    }
                    catch (Throwable t) {
                        artifact.dispose();
                        logger.error("Failed to deploy artifact [{}]", (Object)artifact.getArtifactName());
                        throw t;
                    }
                });
                try {
                    startTask.get();
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
            ArtifactStoppedDeploymentPersistenceListener artifactStoppedDeploymentListener = new ArtifactStoppedDeploymentPersistenceListener(artifact.getArtifactName());
            ArtifactFactoryUtils.withArtifactMuleContext(artifact, muleContext -> {
                MuleRegistry muleRegistry = ((MuleContextWithRegistry)muleContext).getRegistry();
                muleRegistry.registerObject("artifactStoppedPersistenceListener", artifactStoppedDeploymentListener);
            });
        }
        catch (Throwable t) {
            artifact.dispose();
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            throw new DeploymentException(I18nMessageFactory.createStaticMessage("Failed to deploy artifact [%s]", artifact.getArtifactName()), t);
        }
    }

    private void addFlowStoppedListeners(T artifact) {
        this.appsFlowStoppedListeners.put(artifact.getArtifactName(), new ArrayList());
        if (artifact.getArtifactContext() != null && artifact.getArtifactContext().getRegistry() != null) {
            for (Flow flow : artifact.getArtifactContext().getRegistry().lookupAllByType(Flow.class)) {
                String flowName = flow.getName();
                String artifactName = artifact.getArtifactName();
                ((DefaultFlowBuilder.DefaultFlow)flow).setIsStatePersisted(() -> this.isStatePersisted(flowName, artifactName));
                FlowStoppedDeploymentPersistenceListener flowStoppedPersistenceListener = new FlowStoppedDeploymentPersistenceListener(flow.getName(), artifact.getArtifactName());
                ((DefaultFlowBuilder.DefaultFlow)flow).addFlowStoppedListener(flowStoppedPersistenceListener);
                this.appsFlowStoppedListeners.get(artifact.getArtifactName()).add(flowStoppedPersistenceListener);
            }
        }
    }

    public Boolean isStatePersisted(String flowName, String appName) {
        Optional<Properties> deploymentProperties = DeploymentPropertiesUtils.getPersistedFlowDeploymentProperties(appName);
        return deploymentProperties.isPresent() && deploymentProperties.get().getProperty(flowName + "_startFlowOnDeployment") != null;
    }

    private void doInit(T artifact) {
        boolean lazyInit = false;
        boolean addToolingObjectsToRegistry = false;
        boolean enableXmlValidations = false;
        if (((DeployableArtifactDescriptor)artifact.getDescriptor()).getDeploymentProperties().isPresent()) {
            Properties deploymentProperties = ((DeployableArtifactDescriptor)artifact.getDescriptor()).getDeploymentProperties().get();
            lazyInit = Boolean.valueOf((String)deploymentProperties.getOrDefault((Object)"mule.application.deployment.lazyInit", "false"));
            addToolingObjectsToRegistry = Boolean.valueOf((String)deploymentProperties.getOrDefault((Object)"mule.application.deployment.addToolingObjectsToRegistry", "false"));
            enableXmlValidations = Boolean.valueOf((String)deploymentProperties.getOrDefault((Object)"mule.application.deployment.lazyInit.enableXmlValidations", "false"));
        }
        if (lazyInit) {
            if (addToolingObjectsToRegistry) {
                artifact.lazyInitTooling(!enableXmlValidations);
            } else {
                artifact.lazyInit(!enableXmlValidations);
            }
        } else if (addToolingObjectsToRegistry) {
            artifact.initTooling();
        } else {
            artifact.init();
        }
    }

    @Override
    public void undeploy(T artifact) {
        try {
            this.doNotPersistArtifactStop(artifact);
            this.tryToStopArtifact(artifact);
            this.deletePersistence(artifact);
            this.tryToDisposeArtifact(artifact);
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = String.format("Failed to undeployArtifact artifact [%s]", artifact.getArtifactName());
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
    }

    private void tryToDisposeArtifact(T artifact) {
        try {
            artifact.dispose();
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to cleanly dispose artifact '%s'. Restart Mule if you get errors redeploying this artifact", artifact.getArtifactName()), t);
        }
    }

    private void tryToStopArtifact(T artifact) {
        try {
            artifact.stop();
        }
        catch (Throwable t) {
            logger.error(String.format("Unable to cleanly stop artifact '%s'. Restart Mule if you get errors redeploying this artifact", artifact.getArtifactName()), t);
        }
    }

    private Boolean shouldStartArtifactAccordingToPersistedStatus(T artifact) {
        Optional<Properties> artifactStatusProperties = DeploymentPropertiesUtils.getPersistedArtifactStatusDeploymentProperties(artifact.getArtifactName());
        return artifactStatusProperties.isPresent() && Boolean.parseBoolean(artifactStatusProperties.get().getProperty("startArtifactOnDeployment", "true"));
    }

    @Override
    public void doNotPersistArtifactStop(T artifact) {
        if (artifact.getArtifactContext() != null && artifact.getArtifactContext().getRegistry() != null) {
            Optional<ArtifactStoppedPersistenceListener> optionalArtifactStoppedListener = artifact.getArtifactContext().getRegistry().lookupByName("artifactStoppedPersistenceListener");
            optionalArtifactStoppedListener.ifPresent(ArtifactStoppedPersistenceListener::doNotPersist);
        }
    }

    private void deletePersistence(T artifact) {
        if (artifact.getArtifactContext() != null && artifact.getArtifactContext().getRegistry() != null) {
            Optional<ArtifactStoppedPersistenceListener> optionalArtifactStoppedListener = artifact.getArtifactContext().getRegistry().lookupByName("artifactStoppedPersistenceListener");
            optionalArtifactStoppedListener.ifPresent(ArtifactStoppedPersistenceListener::deletePersistenceProperties);
        }
    }
}

