/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.collection;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.streaming.HasSize;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;

public class TransformingIterator<T>
implements Iterator<T> {
    protected final Iterator<?> delegate;
    private final Function<Object, T> transformer;

    public static <T> TransformingIterator<T> from(Iterator<?> delegate, Function<Object, T> transformer) {
        if (delegate instanceof StreamingIterator) {
            return new TransformingStreamingIterator<T>((StreamingIterator)delegate, transformer);
        }
        if (delegate instanceof HasSize) {
            return new TransformingSizedIterator<T>(delegate, transformer);
        }
        return new TransformingIterator<T>(delegate, transformer);
    }

    private TransformingIterator(Iterator<?> delegate, Function<Object, T> transformer) {
        this.delegate = delegate;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        Object value = this.delegate.next();
        return this.transformer.apply(value);
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.delegate.forEachRemaining((? super E value) -> action.accept((T)this.transformer.apply(value)));
    }

    private static class TransformingStreamingIterator<T>
    extends TransformingIterator<T>
    implements StreamingIterator<T> {
        private TransformingStreamingIterator(StreamingIterator<?> delegate, Function<Object, T> transformer) {
            super(delegate, transformer);
        }

        @Override
        public int getSize() {
            return ((StreamingIterator)this.delegate).getSize();
        }

        @Override
        public void close() throws IOException {
            ((StreamingIterator)this.delegate).close();
        }
    }

    private static class TransformingSizedIterator<T>
    extends TransformingIterator<T>
    implements HasSize {
        private TransformingSizedIterator(Iterator<?> delegate, Function<Object, T> transformer) {
            super(delegate, transformer);
        }

        @Override
        public int getSize() {
            return ((HasSize)((Object)this.delegate)).getSize();
        }
    }
}

