/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.core.internal.util.cache.CacheIdBuilderAdapter;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheIdGenerator;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.ComponentBasedIdHelper;
import org.mule.runtime.metadata.internal.cache.GenerationUtils;

public class ComponentAstBasedValueProviderCacheIdGenerator
implements ValueProviderCacheIdGenerator<ComponentAst> {
    private final ComponentLocator<ComponentAst> locator;
    private static final String VALUE_PROVIDER = "ValueProvider";

    public ComponentAstBasedValueProviderCacheIdGenerator(ComponentLocator<ComponentAst> locator) {
        this.locator = locator;
    }

    @Override
    public Optional<ValueProviderCacheId> getIdForResolvedValues(ComponentAst containerComponent, String parameterName) {
        return this.ifContainsParameter(containerComponent, parameterName).flatMap(ParameterModel::getValueProviderModel).flatMap(valueProviderModel -> this.resolveParametersInformation(containerComponent).flatMap(infoMap -> this.resolveId(containerComponent, (ValueProviderModel)valueProviderModel, (Map<String, ParameterModelInformation>)infoMap)));
    }

    @Override
    public Optional<ValueProviderCacheId> getIdForResolvedValues(ComponentAst containerComponent, String parameterName, String targetPath) {
        return this.ifContainsParameter(containerComponent, parameterName).flatMap(pm -> pm.getFieldValueProviderModels().stream().filter(fm -> Objects.equal((Object)fm.getTargetSelector(), (Object)targetPath)).findAny()).flatMap(fieldModel -> this.resolveParametersInformation(containerComponent).flatMap(infoMap -> this.resolveId(containerComponent, (ValueProviderModel)fieldModel, (Map<String, ParameterModelInformation>)infoMap)));
    }

    private Optional<ParameterModel> ifContainsParameter(ComponentAst containerComponent, String parameterName) {
        return containerComponent.getModel(ParameterizedModel.class).flatMap(parameterizedModel -> parameterizedModel.getAllParameterModels().stream().filter(p -> Objects.equal((Object)parameterName, (Object)p.getName())).findAny());
    }

    private Optional<Map<String, ParameterModelInformation>> resolveParametersInformation(ComponentAst containerComponent) {
        return containerComponent.getModel(ParameterizedModel.class).map(parameterizedModel -> containerComponent.getParameters().stream().map(ParameterModelInformation::new).collect(Collectors.toMap(i -> i.getParameterModel().getName(), Function.identity())));
    }

    private Optional<ValueProviderCacheId> resolveId(ComponentAst containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        Optional<ComponentModel> compModel = containerComponent.getModel(ComponentModel.class);
        return compModel.map(c -> this.resolveForComponentModel(containerComponent, valueProviderModel, parameterModelsInformation)).orElse(this.resolveForGlobalElement(containerComponent, valueProviderModel, parameterModelsInformation));
    }

    private Optional<ValueProviderCacheId> resolveForGlobalElement(ComponentAst containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        LinkedList<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>(this.resolveActingParameterIds(containerComponent, valueProviderModel, parameterModelsInformation));
        parts.add(this.resolveValueProviderId(valueProviderModel));
        parts.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName(VALUE_PROVIDER).withHashValueFrom(VALUE_PROVIDER)));
        String id = ComponentBasedIdHelper.sourceElementName(containerComponent);
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName(id).withHashValueFrom(this.resolveDslTagNamespace(containerComponent)).containing(parts)));
    }

    private Optional<ValueProviderCacheId> resolveForComponentModel(ComponentAst containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        LinkedList<ValueProviderCacheId> parts = new LinkedList<ValueProviderCacheId>();
        parts.addAll(this.resolveActingParameterIds(containerComponent, valueProviderModel, parameterModelsInformation));
        parts.addAll(this.resolveIdForInjectedElements(containerComponent, valueProviderModel));
        parts.add(this.resolveValueProviderId(valueProviderModel));
        parts.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName(VALUE_PROVIDER).withHashValueFrom(VALUE_PROVIDER)));
        String id = containerComponent.getIdentifier().toString();
        return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName(id).withHashValueFrom(this.resolveDslTagNamespace(containerComponent)).containing(parts)));
    }

    private String resolveDslTagNamespace(ComponentAst containerComponent) {
        return containerComponent.getIdentifier().getNamespace().toLowerCase();
    }

    private List<ValueProviderCacheId> resolveIdForInjectedElements(ComponentAst containerComponent, ValueProviderModel valueProviderModel) {
        if (!valueProviderModel.requiresConfiguration() && !valueProviderModel.requiresConnection()) {
            return Collections.emptyList();
        }
        return ComponentBasedIdHelper.resolveConfigName(containerComponent).flatMap(config -> this.locator.get(Location.builder().globalName((String)config).build())).filter(configDslElementModel -> configDslElementModel.getModel(ConfigurationModel.class).isPresent()).map(configDslElementModel -> {
            LinkedList injectableIds = new LinkedList();
            if (valueProviderModel.requiresConfiguration()) {
                this.resolveIdForInjectedElement((ComponentAst)configDslElementModel).ifPresent(id -> injectableIds.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName("config: ").containing((ValueProviderCacheId)id))));
            }
            if (valueProviderModel.requiresConnection()) {
                configDslElementModel.directChildrenStream().filter(nested -> nested.getModel(ConnectionProviderModel.class).isPresent()).forEach(connectionProvider -> this.resolveIdForInjectedElement((ComponentAst)connectionProvider).ifPresent(id -> injectableIds.add(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName("connection: ").containing((ValueProviderCacheId)id)))));
            }
            return injectableIds;
        }).orElse(Collections.emptyList());
    }

    private Optional<ValueProviderCacheId> resolveIdForInjectedElement(ComponentAst injectedElement) {
        return injectedElement.getModel(EnrichableModel.class).flatMap(enrichableModel -> {
            List parametersRequiredForMetadata = enrichableModel.getModelProperty(RequiredForMetadataModelProperty.class).map(RequiredForMetadataModelProperty::getRequiredParameters).orElse(Collections.emptyList());
            List<ValueProviderCacheId> parts = this.resolveParametersInformation(injectedElement).map(pi -> parametersRequiredForMetadata.stream().filter(pi::containsKey).map(requiredParameter -> this.resolveParameterId(injectedElement, ((ParameterModelInformation)pi.get(requiredParameter)).getParameterAst())).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (parts.isEmpty()) {
                return Optional.empty();
            }
            String sourceElementName = ComponentBasedIdHelper.sourceElementNameFromSimpleValue(injectedElement);
            return Optional.of(ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName(sourceElementName).withHashValueFrom(sourceElementName).containing(parts)));
        });
    }

    private ValueProviderCacheId resolveValueProviderId(ValueProviderModel valueProviderModel) {
        return ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName("providerId: " + valueProviderModel.getProviderId()).withHashValueFrom(valueProviderModel.getProviderId()));
    }

    private List<ValueProviderCacheId> resolveActingParameterIds(ComponentAst containerComponent, ValueProviderModel valueProviderModel, Map<String, ParameterModelInformation> parameterModelsInformation) {
        return valueProviderModel.getParameters().stream().map(ActingParameterModel::getExtractionExpression).map(GenerationUtils::getParameterNameFromExtractionExpression).filter(parameterModelsInformation::containsKey).map(parameterModelsInformation::get).map(ParameterModelInformation::getParameterAst).map(ast -> this.resolveParameterId(containerComponent, (ComponentParameterAst)ast)).collect(Collectors.toList());
    }

    private ValueProviderCacheId resolveParameterId(ComponentAst containerComponent, ComponentParameterAst componentParameterAst) {
        return (ValueProviderCacheId)ComponentBasedIdHelper.computeIdFor(containerComponent, componentParameterAst, ValueProviderCacheIdBuilderAdapter::new);
    }

    private static class ParameterModelInformation {
        private final ComponentParameterAst parameterAst;

        private ParameterModelInformation(ComponentParameterAst p) {
            this.parameterAst = p;
        }

        private ParameterModel getParameterModel() {
            return this.parameterAst.getModel();
        }

        private ComponentParameterAst getParameterAst() {
            return this.parameterAst;
        }
    }

    private static class ValueProviderCacheIdBuilderAdapter
    implements CacheIdBuilderAdapter<ValueProviderCacheId> {
        private ValueProviderCacheId.ValueProviderCacheIdBuilder builder;

        private ValueProviderCacheIdBuilderAdapter() {
        }

        @Override
        public CacheIdBuilderAdapter<ValueProviderCacheId> withSourceElementName(String name) {
            this.builder = ValueProviderCacheId.ValueProviderCacheIdBuilder.fromElementWithName(name);
            return this;
        }

        @Override
        public CacheIdBuilderAdapter<ValueProviderCacheId> withHashValue(int value) {
            this.validateInitialized();
            this.builder.withHashValue(value);
            return this;
        }

        @Override
        public CacheIdBuilderAdapter<ValueProviderCacheId> containing(List<ValueProviderCacheId> parts) {
            this.validateInitialized();
            this.builder.containing(parts);
            return this;
        }

        @Override
        public ValueProviderCacheId build() {
            this.validateInitialized();
            return ValueProviderCacheId.ValueProviderCacheIdBuilder.aValueProviderCacheId(this.builder);
        }

        private void validateInitialized() {
            if (this.builder == null) {
                throw new RuntimeException("withSourceElementName() never called");
            }
        }
    }
}

