/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.types;

import java.util.Optional;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.property.ResolverInformation;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.mule.runtime.metadata.internal.types.AbstractMetadataResolutionTypeInformation;

public class InputMetadataResolutionTypeInformation
extends AbstractMetadataResolutionTypeInformation {
    public static final String TYPE_IDENTIFIER = "Input";
    private final MetadataCacheId componentTypeMetadataCacheId;

    public InputMetadataResolutionTypeInformation(ComponentAst component, String parameterName) {
        super(component, (TypeResolversInformationModelProperty typeResolversInformationModelProperty) -> InputMetadataResolutionTypeInformation.getResolverInformation(typeResolversInformationModelProperty, parameterName));
        Preconditions.checkArgument(component.getModel(ParameterizedModel.class).isPresent(), "Cannot generate an Input Cache Key for a component with no parameters");
        Preconditions.checkArgument(component.getModel(ParameterizedModel.class).get().getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals(parameterName)), "Cannot generate an Input Cache Key for the component since it does not have a parameter named " + parameterName);
        this.componentTypeMetadataCacheId = this.getTypeCacheId(parameterName);
    }

    public InputMetadataResolutionTypeInformation(DslElementModel<?> component, String parameterName) {
        super(component, (TypeResolversInformationModelProperty typeResolversInformationModelProperty) -> InputMetadataResolutionTypeInformation.getResolverInformation(typeResolversInformationModelProperty, parameterName));
        Preconditions.checkArgument(component.getModel() != null, "Cannot generate an Input Cache Key for a 'null' component");
        Preconditions.checkArgument(component.getModel() instanceof ParameterizedModel, "Cannot generate an Input Cache Key for a component with no parameters");
        Preconditions.checkArgument(((ParameterizedModel)component.getModel()).getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals(parameterName)), "Cannot generate an Input Cache Key for the component since it does not have a parameter named " + parameterName);
        this.componentTypeMetadataCacheId = this.getTypeCacheId(parameterName);
    }

    private MetadataCacheId getTypeCacheId(String parameterName) {
        String parameterTypeIdentifier = this.isDynamicType() ? TYPE_IDENTIFIER : String.format("%s with parameter name : %s", TYPE_IDENTIFIER, parameterName);
        return new MetadataCacheId(parameterTypeIdentifier.hashCode(), parameterTypeIdentifier);
    }

    @Override
    public MetadataCacheId getComponentTypeMetadataCacheId() {
        return this.componentTypeMetadataCacheId;
    }

    protected static Optional<ResolverInformation> getResolverInformation(TypeResolversInformationModelProperty typeResolversInformationModelProperty, String parameterName) {
        return typeResolversInformationModelProperty.getParameterResolver(parameterName);
    }
}

