/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;

public class ObjectToOutputHandler
extends AbstractTransformer
implements DiscoverableTransformer {
    private ObjectSerializer objectSerializer;
    private int priorityWeighting = 2;

    public ObjectToOutputHandler() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.registerSourceType(DataType.fromType(Serializable.class));
        this.setReturnDataType(DataType.fromType(OutputHandler.class));
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src instanceof String) {
            return (event, out) -> out.write(((String)src).getBytes(encoding));
        }
        if (src instanceof byte[]) {
            return (event, out) -> out.write((byte[])src);
        }
        if (src instanceof CursorStreamProvider) {
            return this.handleInputStream((InputStream)((CursorStreamProvider)src).openCursor());
        }
        if (src instanceof InputStream) {
            return this.handleInputStream((InputStream)src);
        }
        if (src instanceof Serializable) {
            return (event, out) -> this.objectSerializer.getExternalProtocol().serialize(src, out);
        }
        throw new TransformerException(I18nMessageFactory.createStaticMessage("Unable to convert " + String.valueOf(src.getClass()) + " to OutputHandler."));
    }

    private OutputHandler handleInputStream(InputStream is) {
        return (event, out) -> {
            try {
                IOUtils.copyLarge((InputStream)is, (OutputStream)out);
            }
            finally {
                is.close();
            }
        };
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }

    @Inject
    @Named(value="_muleDefaultObjectSerializer")
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }
}

