/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.types;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.property.ResolverInformation;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.mule.runtime.metadata.internal.types.MetadataResolutionTypeInformation;

public abstract class AbstractMetadataResolutionTypeInformation
implements MetadataResolutionTypeInformation {
    private String resolverCategory;
    private String resolverName;

    private void setPrivateFields(EnrichableModel enrichableModel, Function<TypeResolversInformationModelProperty, Optional<ResolverInformation>> getResolverInformationFromModelProperty) {
        Optional<TypeResolversInformationModelProperty> typeResolversInformationModelProperty = enrichableModel.getModelProperty(TypeResolversInformationModelProperty.class);
        if (typeResolversInformationModelProperty.isPresent()) {
            this.resolverName = getResolverInformationFromModelProperty.apply(typeResolversInformationModelProperty.get()).map(resolverInformation -> resolverInformation.getResolverName()).orElse(null);
            this.resolverCategory = typeResolversInformationModelProperty.get().getCategoryName();
        }
    }

    public AbstractMetadataResolutionTypeInformation(ComponentAst component, Function<TypeResolversInformationModelProperty, Optional<ResolverInformation>> getResolverInformationFromModelProperty) {
        component.getModel(EnrichableModel.class).ifPresent(em -> this.setPrivateFields((EnrichableModel)em, getResolverInformationFromModelProperty));
    }

    public AbstractMetadataResolutionTypeInformation(DslElementModel<?> component, Function<TypeResolversInformationModelProperty, Optional<ResolverInformation>> getResolverInformationFromModelProperty) {
        if (component.getModel() instanceof EnrichableModel) {
            this.setPrivateFields((EnrichableModel)component.getModel(), getResolverInformationFromModelProperty);
        }
    }

    public AbstractMetadataResolutionTypeInformation(ComponentParameterization parameterization, Function<TypeResolversInformationModelProperty, Optional<ResolverInformation>> getResolverInformationFromModelProperty) {
        Object model = parameterization.getModel();
        if (model instanceof EnrichableModel) {
            this.setPrivateFields((EnrichableModel)model, getResolverInformationFromModelProperty);
        }
    }

    @Override
    public boolean isDynamicType() {
        return this.resolverCategory != null && this.resolverName != null;
    }

    @Override
    public Optional<String> getResolverName() {
        return Optional.ofNullable(this.resolverName);
    }

    @Override
    public Optional<String> getResolverCategory() {
        return Optional.ofNullable(this.resolverCategory);
    }
}

