/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.internal.util.PropertiesUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathMuleCoreExtensionDiscoverer
implements MuleCoreExtensionDiscoverer {
    public static final String CORE_EXTENSION_RESOURCE_NAME = "META-INF/org/mule/runtime/core/config/core-extensions.properties";
    private static Logger logger = LoggerFactory.getLogger(ClasspathMuleCoreExtensionDiscoverer.class);
    private final ArtifactClassLoader containerClassLoader;

    public ClasspathMuleCoreExtensionDiscoverer(ArtifactClassLoader containerClassLoader) {
        Objects.requireNonNull(containerClassLoader, "Container classLoader cannot be null");
        this.containerClassLoader = containerClassLoader;
    }

    @Override
    public List<MuleCoreExtension> discover() throws MuleException {
        Enumeration<URL> e;
        LinkedList<MuleCoreExtension> result = new LinkedList<MuleCoreExtension>();
        try {
            e = Thread.currentThread().getContextClassLoader().getResources(CORE_EXTENSION_RESOURCE_NAME);
        }
        catch (IOException ex) {
            throw new DefaultMuleException("Error loading Mule core extensions", (Throwable)ex);
        }
        LinkedList<Properties> extensions = new LinkedList<Properties>();
        while (e.hasMoreElements()) {
            try {
                URL url = e.nextElement();
                if (logger.isDebugEnabled()) {
                    logger.debug("Reading extension file: {}", (Object)url);
                }
                extensions.add(PropertiesUtils.loadProperties(IOUtils.getInputStreamWithCacheControl(url)));
            }
            catch (Exception ex) {
                throw new DefaultMuleException("Error loading Mule core extensions", (Throwable)ex);
            }
        }
        for (Properties extProps : extensions) {
            for (Map.Entry<Object, Object> entry : extProps.entrySet()) {
                String extName = (String)entry.getKey();
                String extClass = (String)entry.getValue();
                try {
                    MuleCoreExtension extension = (MuleCoreExtension)Class.forName(extClass, true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    extension.setContainerClassLoader(this.containerClassLoader);
                    result.add(extension);
                }
                catch (Throwable t) {
                    throw new DefaultMuleException(String.format("Error starting Mule core extension '%s'. Extension class is %s", extName, extClass), t);
                }
            }
        }
        result.sort(Comparator.comparingInt(MuleCoreExtension::priority));
        return result;
    }
}

