/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.model.ApplicationModelAstPostProcessor;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.mule.runtime.extension.internal.ast.MacroExpansionModulesModel;

public class MacroExpansionAstPostProcessor
implements ApplicationModelAstPostProcessor {
    @Override
    public ArtifactAst postProcessAst(ArtifactAst ast, Set<ExtensionModel> extensionModels, Optional<FeatureFlaggingService> featureFlaggingService) {
        return new MacroExpansionModulesModel(ast, extensionModels, featureFlaggingService).expand();
    }

    @Override
    public Set<ComponentAst> resolveRootComponents(Collection<ComponentAst> rootComponents, Set<ExtensionModel> extensionModels) {
        Set xmlSdk1ConfigModels = Collections.newSetFromMap(new IdentityHashMap());
        extensionModels.stream().flatMap(extension -> extension.getModelProperty(XmlExtensionModelProperty.class).map(mp -> extension.getConfigurationModels().stream()).orElse(Stream.empty())).forEach(xmlSdk1ConfigModels::add);
        return Stream.concat(rootComponents.stream(), rootComponents.stream().flatMap(root -> root.recursiveStream().filter(comp -> comp.getModel(ConfigurationModel.class).map(xmlSdk1ConfigModels::contains).orElse(comp.getIdentifier().getName().equals("_defaultGlobalElements"))).flatMap(ComponentAst::directChildrenStream))).filter(comp -> !comp.getIdentifier().getName().equals("_defaultGlobalElements")).collect(Collectors.toSet());
    }
}

