/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.support.internal.protocol.Http1ProtocolConfigurerImpl;
import org.mule.runtime.http.support.internal.protocol.Http2ProtocolConfigurerImpl;
import org.mule.sdk.api.http.protocol.Http1ProtocolConfigurer;
import org.mule.sdk.api.http.protocol.Http2ProtocolConfigurer;
import org.mule.sdk.api.http.server.HttpServerConfigurer;

public final class HttpServerConfigToBuilder
implements HttpServerConfigurer {
    private final HttpServerConfiguration.Builder builder;

    public HttpServerConfigToBuilder(HttpServerConfiguration.Builder builder) {
        this.builder = builder;
    }

    @Override
    public HttpServerConfigurer setHost(String host) {
        this.builder.setHost(host);
        return this;
    }

    @Override
    public HttpServerConfigurer setPort(int port) {
        this.builder.setPort(port);
        return this;
    }

    @Override
    public HttpServerConfigurer setTlsContextFactory(TlsContextFactory tlsContextFactory) {
        this.builder.setTlsContextFactory(tlsContextFactory);
        return this;
    }

    @Override
    public HttpServerConfigurer setUsePersistentConnections(boolean usePersistentConnections) {
        this.builder.setUsePersistentConnections(usePersistentConnections);
        return this;
    }

    @Override
    public HttpServerConfigurer setConnectionIdleTimeout(int connectionIdleTimeout) {
        this.builder.setConnectionIdleTimeout(connectionIdleTimeout);
        return this;
    }

    @Override
    public HttpServerConfigurer setSchedulerSupplier(Supplier<Scheduler> schedulerSupplier) {
        this.builder.setSchedulerSupplier(schedulerSupplier);
        return this;
    }

    @Override
    public HttpServerConfigurer setName(String name) {
        this.builder.setName(name);
        return this;
    }

    @Override
    public HttpServerConfigurer setReadTimeout(long readTimeout) {
        this.builder.setReadTimeout(readTimeout);
        return this;
    }

    @Override
    public HttpServerConfigurer configHttp1(Consumer<Http1ProtocolConfigurer> configCallback) {
        Http1ProtocolConfig config = new Http1ProtocolConfig(true);
        configCallback.accept(new Http1ProtocolConfigurerImpl(config));
        this.builder.setHttp1Config(config);
        return this;
    }

    @Override
    public HttpServerConfigurer configHttp2(Consumer<Http2ProtocolConfigurer> configCallback) {
        Http2ProtocolConfig config = new Http2ProtocolConfig(true);
        configCallback.accept(new Http2ProtocolConfigurerImpl(config));
        this.builder.setHttp2Config(config);
        return this;
    }
}

