/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceFactoryContext;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.ReverseSdkConnectionProviderAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacySourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SourceTransactionalActionUtils;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class SourceConfigurer {
    private final SourceFactoryContext context;
    private final ReflectionCache reflectionCache = new ReflectionCache();

    public SourceConfigurer(SourceFactoryContext context) {
        this.context = context;
    }

    public Source<?, ?> configure(Object source) {
        Object model = this.context.getParameterization().getModel();
        for (ParameterGroupModel pgm : model.getParameterGroupModels()) {
            if (pgm.getName().equals("General")) {
                for (ParameterModel pm : pgm.getParameterModels()) {
                    IntrospectionUtils.getField(source.getClass(), IntrospectionUtils.getImplementingName(pm), this.reflectionCache).ifPresent(field -> {
                        Object fieldValue = this.context.getParameterization().getParameter(pgm, pm);
                        if (fieldValue != null) {
                            new FieldSetter<Object, Object>((Field)field).set(source, this.adaptToLegacyIfNeeded(fieldValue, field.getType()));
                        }
                    });
                }
                continue;
            }
            pgm.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).ifPresent(desc -> {
                AnnotatedElement patt5007$temp = desc.getContainer();
                if (patt5007$temp instanceof Field) {
                    Field field = (Field)patt5007$temp;
                    Class<?> prototypeClass = desc.getType().getDeclaringClass().get();
                    IntrospectionUtils.checkInstantiable(prototypeClass, this.reflectionCache);
                    List<FieldElement> groupDescriptorFields = this.reflectionCache.fieldElementsFor((ParameterGroupDescriptor)desc).stream().filter(fieldElement -> fieldElement.getField().map(TypeUtils::isParameter).orElse(false)).toList();
                    Object fieldValue = SourceConfigurer.createInstance(prototypeClass);
                    for (FieldElement groupField : groupDescriptorFields) {
                        Object resolvedValue = this.context.getParameterization().getParameter(pgm.getName(), groupField.getAlias());
                        if (resolvedValue == null) continue;
                        Object value = ResolverUtils.resolveCursorAsUnclosable(resolvedValue);
                        groupField.set(fieldValue, this.adaptToLegacyIfNeeded(value, field.getType()));
                    }
                    new FieldSetter(field).set(source, fieldValue);
                }
            });
        }
        if (model instanceof EnrichableModel) {
            EnrichableModel enrichableModel = (EnrichableModel)model;
            IntrospectionUtils.injectDefaultEncoding(enrichableModel, source, this.context.getDefaultEncoding());
            IntrospectionUtils.injectRuntimeVersion(enrichableModel, source, this.context.getRuntimeVersion());
        }
        IntrospectionUtils.injectComponentLocation(source, this.context.getComponentLocation());
        this.context.getConfigurationInstance().ifPresent(configurationInstance -> {
            IntrospectionUtils.injectRefName(source, configurationInstance.getName(), this.reflectionCache);
            this.setConfiguration(source, (ConfigurationInstance)configurationInstance);
        });
        this.context.getConnectionProvider().ifPresent(connectionProvider -> this.setConnection(source, (ConnectionProvider<?>)connectionProvider));
        return LegacySourceAdapterFactory.createAdapter(source);
    }

    private Object adaptToLegacyIfNeeded(Object value, Class<?> targetType) {
        if (targetType.isAssignableFrom(SourceTransactionalAction.class)) {
            return SourceTransactionalActionUtils.toLegacy(value);
        }
        return value;
    }

    private static <T> T createInstance(Class<T> prototypeClass) {
        try {
            return prototypeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of " + String.valueOf(prototypeClass)), e.getTargetException());
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of " + String.valueOf(prototypeClass)), (Throwable)e);
        }
    }

    private Optional<Field> fetchConnectionProviderField(Object source) {
        Optional<Field> connectionField = IntrospectionUtils.fetchConnectionFieldFromSourceObject(source);
        connectionField.filter(field -> !this.fieldAcceptsConnectionProvider((Field)field)).ifPresent(field -> {
            throw new IllegalModelDefinitionException(String.format("Message Source defined on class '%s' has field '%s' of type '%s' annotated with @%s. That annotation can only be used on fields of type '%s' or '%s'", source.getClass().getName(), field.getName(), field.getType().getName(), Connection.class.getSimpleName(), ConnectionProvider.class.getName(), org.mule.sdk.api.connectivity.ConnectionProvider.class.getName()));
        });
        return connectionField;
    }

    private boolean fieldAcceptsConnectionProvider(Field field) {
        return ConnectionProvider.class.equals(field.getType()) || org.mule.sdk.api.connectivity.ConnectionProvider.class.equals(field.getType());
    }

    private void setConfiguration(Object source, ConfigurationInstance configuration) {
        Optional<Field> configurationField = IntrospectionUtils.fetchConfigFieldFromSourceObject(source);
        configurationField.ifPresent(field -> new FieldSetter<Object, Object>((Field)field).set(source, configuration.getValue()));
    }

    private void setConnection(Object source, ConnectionProvider<?> connectionProvider) {
        this.fetchConnectionProviderField(source).ifPresent(field -> {
            Object adaptedConnectionProvider = connectionProvider;
            if (org.mule.sdk.api.connectivity.ConnectionProvider.class.isAssignableFrom(field.getType())) {
                adaptedConnectionProvider = ReverseSdkConnectionProviderAdapter.from(connectionProvider);
            }
            new FieldSetter<Object, Object>((Field)field).set(source, adaptedConnectionProvider);
        });
    }
}

