/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentPropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeploymentPropertiesUtils.class);
    private static final String DEPLOYMENT_PROPERTIES_FILE_NAME = "deployment.properties";
    private static final String FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME = "flows.deployment.properties";
    private static final String DEPLOYMENT_PROPERTIES_DIRECTORY = "deployment-properties";
    private static final String ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME = "artifact.status.deployment.properties";

    public static Properties resolveDeploymentProperties(String artifactName, Optional<Properties> deploymentProperties, String fileName) throws IOException {
        Properties properties = deploymentProperties.orElse(new Properties());
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, fileName);
        return properties;
    }

    public static Optional<Properties> getPersistedProperties(String artifactName, String fileName) {
        try {
            String deploymentPropertiesPath = DeploymentPropertiesUtils.getDeploymentPropertiesPath(artifactName);
            return Optional.of(DeploymentPropertiesUtils.getDeploymentProperties(deploymentPropertiesPath, fileName));
        }
        catch (IOException e) {
            LOGGER.error("Failed to load persisted deployment property for artifact " + artifactName, (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<Properties> getPersistedDeploymentProperties(String artifactName) {
        return DeploymentPropertiesUtils.getPersistedProperties(artifactName, DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Optional<Properties> getPersistedFlowDeploymentProperties(String artifactName) {
        return DeploymentPropertiesUtils.getPersistedProperties(artifactName, FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Optional<Properties> getPersistedArtifactStatusDeploymentProperties(String artifactName) {
        return DeploymentPropertiesUtils.getPersistedProperties(artifactName, ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static void setPersistedProperties(String artifactName, Properties properties, String fileName) throws IOException {
        String deploymentPropertiesPath = DeploymentPropertiesUtils.getDeploymentPropertiesPath(artifactName);
        DeploymentPropertiesUtils.initDeploymentPropertiesDirectory(deploymentPropertiesPath);
        DeploymentPropertiesUtils.persistDeploymentPropertiesFile(deploymentPropertiesPath, properties, fileName);
    }

    public static void setPersistedDeploymentProperties(String artifactName, Properties properties) throws IOException {
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static void setPersistedFlowDeploymentProperties(String artifactName, Properties properties) throws IOException {
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static void setPersistedArtifactStatusDeploymentProperties(String artifactName, Properties properties) throws IOException {
        DeploymentPropertiesUtils.setPersistedProperties(artifactName, properties, ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    private static String getDeploymentPropertiesPath(String artifactName) {
        File file = new File(MuleFoldersUtil.getExecutionFolder(), artifactName);
        String workingDirectory = file.getAbsolutePath();
        return workingDirectory + File.separator + DEPLOYMENT_PROPERTIES_DIRECTORY;
    }

    private static Properties getDeploymentProperties(String deploymentPropertiesPath, String fileName) throws IOException {
        File configFile = new File(deploymentPropertiesPath + File.separator + fileName);
        Properties props = new Properties();
        if (!configFile.exists()) {
            return props;
        }
        try (FileReader reader = new FileReader(configFile);){
            props.load(reader);
        }
        return props;
    }

    private static void initDeploymentPropertiesDirectory(String deploymentPropertiesPath) {
        File deploymentPropertiesDirectory = new File(deploymentPropertiesPath);
        if (!deploymentPropertiesDirectory.exists()) {
            DeploymentPropertiesUtils.createDeploymentPropertiesDirectory(deploymentPropertiesDirectory);
        }
    }

    private static synchronized void createDeploymentPropertiesDirectory(File deploymentPropertiesDirectory) {
        if (!deploymentPropertiesDirectory.exists() && !deploymentPropertiesDirectory.mkdirs()) {
            I18nMessage message = CoreMessages.failedToCreate("deployment properties directory " + deploymentPropertiesDirectory.getAbsolutePath());
            throw new MuleRuntimeException(message);
        }
    }

    private static void persistDeploymentPropertiesFile(String deploymentPropertiesPath, Properties deploymentProperties, String fileName) throws IOException {
        File deploymentPropertiesFile = new File(deploymentPropertiesPath, fileName);
        try (FileWriter fileWriter = new FileWriter(deploymentPropertiesFile.getAbsolutePath(), false);){
            deploymentProperties.store(fileWriter, "deployment properties");
        }
    }

    public static Properties resolveDeploymentProperties(String artifactName, Optional<Properties> deploymentProperties) throws IOException {
        return DeploymentPropertiesUtils.resolveDeploymentProperties(artifactName, deploymentProperties, DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Properties resolveFlowDeploymentProperties(String appName, Optional<Properties> deploymentProperties) throws IOException {
        return DeploymentPropertiesUtils.resolveDeploymentProperties(appName, deploymentProperties, FLOWS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }

    public static Properties resolveArtifactStatusDeploymentProperties(String artifactName, Optional<Properties> statusProperties) throws IOException {
        return DeploymentPropertiesUtils.resolveDeploymentProperties(artifactName, statusProperties, ARTIFACT_STATUS_DEPLOYMENT_PROPERTIES_FILE_NAME);
    }
}

