/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.security;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

@NoExtend
public class MuleSecurityManagerConfigurator
extends AbstractComponentFactory<SecurityManager> {
    private List<SecurityProvider> providers = new ArrayList<SecurityProvider>();
    private List<EncryptionStrategy> encryptionStrategies = new ArrayList<EncryptionStrategy>();
    private MuleContext muleContext;
    private String name = "_muleSecurityManager";

    public void setName(String name) {
        this.name = name;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setProviders(List<SecurityProvider> providers) {
        this.providers = providers;
    }

    public void setEncryptionStrategies(List<EncryptionStrategy> encryptionStrategies) {
        this.encryptionStrategies = encryptionStrategies;
    }

    @Override
    public SecurityManager doGetObject() throws Exception {
        ArrayList<SecurityManager> securityManagers = new ArrayList<SecurityManager>();
        securityManagers.add(this.muleContext.getSecurityManager());
        SecurityManager factorySecurityManager = this.muleContext.getSecurityManager();
        if (!this.name.equals("_muleSecurityManager")) {
            factorySecurityManager = new DefaultMuleSecurityManager();
            securityManagers.add(factorySecurityManager);
        }
        securityManagers.stream().forEach(securityManager -> {
            this.providers.stream().forEach(provider -> securityManager.addProvider((SecurityProvider)provider));
            this.encryptionStrategies.stream().forEach(encryptionStrategy -> securityManager.addEncryptionStrategy((EncryptionStrategy)encryptionStrategy));
        });
        return factorySecurityManager;
    }
}

