/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.data.sample;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.NullCursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.tooling.sampledata.SampleDataProviderMediator;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataProviderFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.SampleDataProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.result.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;

public class DefaultSampleDataProviderMediator
implements SampleDataProviderMediator {
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;
    private final Component component;
    private final ReflectionCache reflectionCache;
    private final ExpressionManager expressionManager;
    private final StreamingManager streamingManager;
    private final SampleDataProviderFactoryModelProperty sampleDataProperty;
    private final ReturnDelegate returnDelegate;
    private final ArtifactEncoding artifactEncoding;
    private final ServerNotificationManager notificationManager;
    private final CursorProviderFactory cursorProviderFactory = new NullCursorProviderFactory();
    private final Injector injector;
    private final MuleContext muleContext;

    public DefaultSampleDataProviderMediator(ExtensionModel extensionModel, ComponentModel componentModel, Component component, ArtifactEncoding artifactEncoding, ServerNotificationManager notificationManager, ReflectionCache reflectionCache, ExpressionManager expressionManager, StreamingManager streamingManager, Injector injector, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
        this.component = component;
        this.artifactEncoding = artifactEncoding;
        this.notificationManager = notificationManager;
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.streamingManager = streamingManager;
        this.injector = injector;
        this.sampleDataProperty = componentModel.getModelProperty(SampleDataProviderFactoryModelProperty.class).orElse(null);
        this.returnDelegate = new ValueReturnDelegate(componentModel, artifactEncoding);
        this.muleContext = muleContext;
    }

    @Override
    public Message getSampleData(ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws SampleDataException {
        return this.getSampleData(parameterValueResolver, connectionSupplier, configurationSupplier, () -> null);
    }

    @Override
    public Message getSampleData(ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, Supplier<ConnectionProvider> connectionProviderSupplier) throws SampleDataException {
        if (this.sampleDataProperty == null) {
            throw new SampleDataException(String.format("Component '%s' does not support Sample Data resolution", this.componentModel.getName()), "NOT_SUPPORTED");
        }
        try {
            SampleDataProviderFactory factory = this.sampleDataProperty.createFactory(parameterValueResolver, connectionSupplier, configurationSupplier, this.reflectionCache, this.expressionManager, this.injector, this.componentModel);
            SampleDataProvider provider = factory.createSampleDataProvider();
            Result result = ExtensionsOAuthUtils.withRefreshToken(connectionProviderSupplier, () -> provider.getSample());
            return this.returnDelegate.asReturnValue(result, this.createExecutionContext(configurationSupplier)).getMessage();
        }
        catch (SampleDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SampleDataException(String.format("An error occurred trying to obtain Sample Data for component '%s'. Cause: %s", this.componentModel.getName(), e.getMessage()), "UNKNOWN", (Throwable)e);
        }
    }

    private ExecutionContextAdapter createExecutionContext(Supplier<Object> configurationSupplier) {
        return new DefaultExecutionContext<ComponentModel>(this.extensionModel, Optional.ofNullable(configurationSupplier.get()), Collections.emptyMap(), this.componentModel, NullEventFactory.getNullEvent(), this.artifactEncoding, this.notificationManager, this.cursorProviderFactory, this.streamingManager, this.component, new NoRetryPolicyTemplate(), ImmediateScheduler.IMMEDIATE_SCHEDULER, Optional.empty(), null, this.muleContext);
    }
}

