/*
 * Decompiled with CFR 0.152.
 */
package org.mule.oauth.client.internal.state;

import org.mule.runtime.api.util.Preconditions;

public class StateEncoder {
    public static final String RESOURCE_OWNER_PARAM_NAME = ":resourceOwnerId";
    public static final String RESOURCE_OWNER_PARAM_NAME_ASSIGN = ":resourceOwnerId=";
    public static final String ON_COMPLETE_REDIRECT_TO_PARAM_NAME = ":onCompleteRedirectTo";
    public static final String ON_COMPLETE_REDIRECT_TO_PARAM_NAME_ASSIGN = ":onCompleteRedirectTo=";
    private String state;

    public StateEncoder(String originalState) {
        this.state = originalState;
    }

    public void encodeResourceOwnerIdInState(String resourceOwnerId) {
        this.encodeParameter(resourceOwnerId, RESOURCE_OWNER_PARAM_NAME_ASSIGN);
    }

    public void encodeOnCompleteRedirectToInState(String onCompleteRedirectToValue) {
        this.encodeParameter(onCompleteRedirectToValue, ON_COMPLETE_REDIRECT_TO_PARAM_NAME_ASSIGN);
    }

    private void encodeParameter(String parameterValue, String parameterAssignation) {
        Preconditions.checkArgument(parameterValue != null, "parameter cannot be null");
        Preconditions.checkArgument(this.state == null || !this.state.contains(ON_COMPLETE_REDIRECT_TO_PARAM_NAME_ASSIGN), "parameter cannot be added after :onCompleteRedirectTo");
        this.state = this.state == null ? parameterAssignation + parameterValue : this.state + parameterAssignation + parameterValue;
    }

    public String getEncodedState() {
        return this.state;
    }
}

