/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackableType;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackedTypesModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterResolverValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticLiteralValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypedValueValueResolverWrapper;
import org.mule.sdk.api.runtime.parameter.Literal;

class StackableTypesModelPropertyResolver {
    private final Map<Type, StackableType> stackableTypes;

    public static StackableTypesModelPropertyResolver newInstance(ExtensionLoadingContext loadingContext) {
        return StackableTypesModelPropertyResolver.builder().addType(StackableType.builder(ParameterResolver.class, loadingContext.getTypeLoader()).setStaticResolverFactory(value -> new StaticValueResolver<StaticParameterResolver<Object>>(new StaticParameterResolver<Object>(value))).setDelegateResolverFactory(resolver -> new ParameterResolverValueResolverWrapper(resolver)).setExpressionBasedResolverFactory((value, expectedType) -> new ExpressionBasedParameterResolverValueResolver(value, expectedType, DataType.fromType(expectedType))).build()).addType(StackableType.builder(TypedValue.class, loadingContext.getTypeLoader()).setStaticResolverFactory(value -> new StaticValueResolver<TypedValue<Object>>(new TypedValue<Object>(value, DataType.fromObject(value)))).setDelegateResolverFactory(valueResolver -> new TypedValueValueResolverWrapper(valueResolver)).setExpressionBasedResolverFactory((expression, expectedType) -> new ExpressionTypedValueValueResolver(expression, expectedType)).build()).addType(StackableType.builder(org.mule.runtime.extension.api.runtime.parameter.Literal.class, loadingContext.getTypeLoader()).setExpressionBasedResolverFactory((expression, expectedType) -> new StaticLiteralValueResolver(expression, expectedType)).setStaticResolverFactory(value -> new StaticLiteralValueResolver(value.toString(), value.getClass())).build()).addType(StackableType.builder(org.mule.sdk.api.runtime.parameter.ParameterResolver.class, loadingContext.getTypeLoader()).setStaticResolverFactory(value -> new StaticValueResolver<StaticParameterResolver<Object>>(new StaticParameterResolver<Object>(value))).setDelegateResolverFactory(resolver -> new ParameterResolverValueResolverWrapper(resolver)).setExpressionBasedResolverFactory((value, expectedType) -> new ExpressionBasedParameterResolverValueResolver(value, expectedType, DataType.fromType(expectedType))).build()).addType(StackableType.builder(Literal.class, loadingContext.getTypeLoader()).setExpressionBasedResolverFactory((expression, expectedType) -> new StaticLiteralValueResolver(expression, expectedType)).setStaticResolverFactory(value -> new StaticLiteralValueResolver(value.toString(), value.getClass())).build()).build();
    }

    private StackableTypesModelPropertyResolver(Map<Type, StackableType> stackableTypes) {
        this.stackableTypes = stackableTypes;
    }

    public List<ModelProperty> resolveStackableProperties(ExtensionParameter parameter, ParameterDeclarationContext declarationContext) {
        LinkedList<ModelProperty> properties = new LinkedList<ModelProperty>();
        LazyValue<Supplier<StackedTypesModelProperty.Builder>> stackedTypesModelPropertyBuilder = new LazyValue<Supplier<StackedTypesModelProperty.Builder>>(StackedTypesModelProperty::builder);
        this.doResolve(parameter, declarationContext, parameter.getType(), stackedTypesModelPropertyBuilder);
        stackedTypesModelPropertyBuilder.ifComputed(builder -> properties.add(builder.build()));
        return properties;
    }

    private void doResolve(ExtensionParameter extensionParameter, ParameterDeclarationContext declarationContext, Type resolvableType, LazyValue<StackedTypesModelProperty.Builder> builder) {
        this.getStackableType(resolvableType).ifPresent(stackableType -> {
            List<TypeGeneric> generics = resolvableType.getGenerics();
            if (generics.isEmpty()) {
                throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] from the %s [%s] doesn't specify the %s parameterized type", extensionParameter.getName(), declarationContext.getComponentType(), declarationContext.getComponentName(), extensionParameter.getType()));
            }
            ((StackedTypesModelProperty.Builder)builder.get()).addType((StackableType)stackableType);
            this.doResolve(extensionParameter, declarationContext, generics.get(0).getConcreteType(), builder);
        });
    }

    private Optional<StackableType> getStackableType(Type type) {
        return this.stackableTypes.entrySet().stream().filter(entry -> ((Type)entry.getKey()).isSameType(type)).map(Map.Entry::getValue).findFirst();
    }

    private static Builder builder() {
        return new Builder();
    }

    private static class Builder {
        private final Map<Type, StackableType> stackableTypes = new HashMap<Type, StackableType>();

        private Builder() {
        }

        public Builder addType(StackableType stackableType) {
            this.stackableTypes.put(stackableType.getType(), stackableType);
            return this;
        }

        public StackableTypesModelPropertyResolver build() {
            return new StackableTypesModelPropertyResolver(this.stackableTypes);
        }
    }
}

