/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.config.api.ArtifactContextFactory;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.internal.artifact.SpringArtifactContext;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.BaseMuleArtifactContext;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.context.lazy.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.model.ComponentModelInitializer;
import org.mule.runtime.config.internal.model.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.registry.BaseSpringRegistry;
import org.mule.runtime.config.internal.registry.SpringRegistry;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.NullDomainMuleContextLifecycleStrategy;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.internal.memory.management.DefaultMemoryManagementService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ArtifactAstConfigurationBuilder
extends AbstractConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder,
ArtifactContextFactory {
    private final boolean enableLazyInit;
    private final ArtifactAst artifactAst;
    private final Map<String, String> artifactProperties;
    private ApplicationContext parentContext;
    private MuleArtifactContext muleArtifactContext;
    private final ArtifactType artifactType;
    private final MemoryManagementService memoryManagementService;
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;

    private ArtifactAstConfigurationBuilder(ArtifactAst artifactAst, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, MemoryManagementService memoryManagementService, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) throws ConfigurationException {
        this.artifactAst = artifactAst;
        this.artifactProperties = artifactProperties;
        this.artifactType = artifactType;
        this.enableLazyInit = enableLazyInit;
        this.memoryManagementService = memoryManagementService;
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
    }

    public ArtifactAstConfigurationBuilder(ArtifactAst artifactAst, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) throws ConfigurationException {
        this(artifactAst, artifactProperties, artifactType, enableLazyInit, DefaultMemoryManagementService.getInstance(), componentBuildingDefinitionRegistry);
    }

    public ArtifactAstConfigurationBuilder(ArtifactAst artifactAst, Map<String, String> artifactProperties) throws ConfigurationException {
        this(artifactAst, artifactProperties, ArtifactType.APP, false, new DefaultComponentBuildingDefinitionRegistryFactory().create(artifactAst.dependencies(), artifactAst::dependenciesDsl));
    }

    @Override
    protected void doConfigure(MuleContext muleContext) throws Exception {
        if (MuleAstUtils.emptyArtifact().equals(this.artifactAst) && this.artifactType == ArtifactType.DOMAIN) {
            ((DefaultMuleContext)muleContext).setLifecycleStrategy(new NullDomainMuleContextLifecycleStrategy());
            return;
        }
        LifecycleUtils.initialiseIfNeeded((Object)this, muleContext);
        Optional<ConfigurationProperties> parentConfigurationProperties = this.resolveParentConfigurationProperties();
        BaseMuleArtifactContext baseMuleArtifactContext = this.createBaseContext(muleContext, parentConfigurationProperties);
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        BaseSpringRegistry baseRegistry = this.createBaseRegistry(muleContext, baseMuleArtifactContext);
        try {
            this.muleArtifactContext = this.createApplicationContext(muleContext, (BaseConfigurationComponentLocator)baseMuleArtifactContext.getBean(BaseConfigurationComponentLocator.class), (ContributedErrorTypeRepository)baseMuleArtifactContext.getBean(ContributedErrorTypeRepository.class), (ContributedErrorTypeLocator)baseMuleArtifactContext.getBean(ContributedErrorTypeLocator.class), (FeatureFlaggingService)baseMuleArtifactContext.getBean(FeatureFlaggingService.class), (ExpressionLanguageMetadataService)baseMuleArtifactContext.getBean(ExpressionLanguageMetadataService.class));
            this.muleArtifactContext.setParent((ApplicationContext)baseMuleArtifactContext);
            this.createSpringRegistry((DefaultMuleContext)muleContext, (ApplicationContext)baseMuleArtifactContext, this.muleArtifactContext);
        }
        catch (Exception e) {
            baseRegistry.dispose();
            throw e;
        }
    }

    private BaseMuleArtifactContext createBaseContext(MuleContext muleContext, Optional<ConfigurationProperties> parentConfigurationProperties) {
        BaseMuleArtifactContext baseMuleArtifactContext = new BaseMuleArtifactContext(muleContext, parentConfigurationProperties, this.getArtifactProperties(), this.artifactType, this.enableLazyInit);
        if (baseMuleArtifactContext instanceof ConfigurableApplicationContext) {
            baseMuleArtifactContext.setParent(this.parentContext);
        }
        return baseMuleArtifactContext;
    }

    private BaseSpringRegistry createBaseRegistry(MuleContext muleContext, BaseMuleArtifactContext baseMuleArtifactContext) throws InitialisationException {
        BaseSpringRegistry baseRegistry = new BaseSpringRegistry((ApplicationContext)baseMuleArtifactContext, muleContext, ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
        ((DefaultMuleContext)muleContext).setRegistry(baseRegistry);
        ((DefaultMuleContext)muleContext).setInjector(baseRegistry);
        baseRegistry.initialise();
        return baseRegistry;
    }

    private MuleArtifactContext createApplicationContext(MuleContext muleContext, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, FeatureFlaggingService featureFlaggingService, ExpressionLanguageMetadataService expressionLanguageMetadataService) throws Exception {
        return this.doCreateApplicationContext(muleContext, baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, featureFlaggingService, expressionLanguageMetadataService);
    }

    private MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, FeatureFlaggingService featureFlaggingService, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        if (this.enableLazyInit) {
            return new LazyMuleArtifactContext(muleContext, this.artifactAst, this.resolveParentConfigurationProperties(), baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, this.getArtifactProperties(), this.artifactType, this.resolveComponentModelInitializer(), this.componentBuildingDefinitionRegistry, new ArtifactMemoryManagementService(this.memoryManagementService), featureFlaggingService, expressionLanguageMetadataService);
        }
        MuleArtifactContext context = new MuleArtifactContext(muleContext, this.artifactAst, this.resolveParentConfigurationProperties(), baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, this.getArtifactProperties(), this.artifactType, this.componentBuildingDefinitionRegistry, new ArtifactMemoryManagementService(this.memoryManagementService), featureFlaggingService, expressionLanguageMetadataService);
        context.initialize();
        return context;
    }

    private Optional<ConfigurationProperties> resolveParentConfigurationProperties() {
        Optional<ConfigurationProperties> parentConfigurationProperties = Optional.empty();
        if (this.parentContext != null) {
            parentConfigurationProperties = Optional.of((ConfigurationProperties)this.parentContext.getBean(ConfigurationProperties.class));
        }
        return parentConfigurationProperties;
    }

    private Optional<ComponentModelInitializer> resolveComponentModelInitializer() {
        Optional<ComponentModelInitializer> parentLazyComponentInitializer = Optional.empty();
        if (this.parentContext instanceof ComponentModelInitializer) {
            parentLazyComponentInitializer = Optional.of((ComponentModelInitializer)this.parentContext);
        }
        return parentLazyComponentInitializer;
    }

    private void createSpringRegistry(DefaultMuleContext muleContext, ApplicationContext baseApplicationContext, MuleArtifactContext applicationContext) throws Exception {
        SpringRegistry registry = this.parentContext != null ? this.createRegistryWithParentContext(muleContext, baseApplicationContext, applicationContext) : new SpringRegistry(baseApplicationContext, (ApplicationContext)applicationContext, muleContext, new ConfigurationDependencyResolver(applicationContext.getApplicationModel()), muleContext.getLifecycleInterceptor());
        muleContext.setRegistry(registry);
        muleContext.setInjector(registry);
    }

    private SpringRegistry createRegistryWithParentContext(MuleContext muleContext, ApplicationContext baseApplicationContext, MuleArtifactContext applicationContext) throws ConfigurationException {
        if (baseApplicationContext instanceof ConfigurableApplicationContext) {
            return new SpringRegistry(baseApplicationContext, (ApplicationContext)applicationContext, muleContext, new ConfigurationDependencyResolver(applicationContext.getApplicationModel()), ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
        }
        throw new ConfigurationException(I18nMessageFactory.createStaticMessage("Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
    }

    @Override
    protected synchronized void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    @Override
    public ArtifactContext createArtifactContext() {
        return new SpringArtifactContext(this.muleArtifactContext);
    }

    @Override
    public void setParentContext(MuleContext domainContext, ArtifactAst parentAst) {
        this.parentContext = (ApplicationContext)((MuleContextWithRegistry)domainContext).getRegistry().get("springApplicationContext");
    }

    public Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }
}

