/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ExclusiveParameterModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            @Override
            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                model.getExclusiveParametersModels().forEach(exclusiveParametersModel -> {
                    Set<String> exclusiveParameterNames = exclusiveParametersModel.getExclusiveParameterNames();
                    if (exclusiveParameterNames.isEmpty()) {
                        problemsReporter.addError(new Problem(owner, String.format("In %s '%s', parameter group '%s' defines an empty set of exclusive parameters", NameUtils.getComponentModelTypeName(owner), NameUtils.getModelName(owner), model.getName())));
                    }
                    if (exclusiveParameterNames.size() < 2) {
                        problemsReporter.addError(new Problem(owner, String.format("In %s '%s', parameter group '%s' defines exclusive optional parameters, and thus should contain more than one parameter marked as optional but %d was/were found", NameUtils.getComponentModelTypeName(owner), NameUtils.getModelName(owner), model.getName(), exclusiveParameterNames.size())));
                    }
                });
            }
        }.walk(extensionModel);
    }
}

