/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;

public class MuleModule
implements MuleContainerModule {
    private final String name;
    private final Set<String> exportedPackages;
    private final Set<String> exportedPaths;
    private final Set<String> privilegedExportedPackages;
    private final Set<String> privilegedArtifacts;
    private final List<ExportedService> exportedServices;

    public MuleModule(String name, Set<String> exportedPackages, Set<String> exportedPaths, Set<String> privilegedExportedPackages, Set<String> privilegedArtifacts, List<ExportedService> exportedServices) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)name), "name cannot be empty");
        Objects.requireNonNull(exportedPackages, "exportedPackages cannot be null");
        Objects.requireNonNull(exportedPaths, "exportedPaths cannot be null");
        Preconditions.checkArgument(!this.containsMetaInfServicesResource(exportedPaths), "exportedPaths cannot contain paths on META-INF/services");
        Objects.requireNonNull(privilegedExportedPackages, "privilegedExportedPackages cannot be null");
        Objects.requireNonNull(privilegedArtifacts, "privilegedArtifacts cannot be null");
        Objects.requireNonNull(exportedServices, "exportedServices cannot be null");
        this.name = name;
        this.exportedPackages = Collections.unmodifiableSet(exportedPackages);
        this.exportedPaths = Collections.unmodifiableSet(exportedPaths);
        this.privilegedExportedPackages = privilegedExportedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
        this.exportedServices = exportedServices;
    }

    private boolean containsMetaInfServicesResource(Set<String> exportedPaths) {
        return exportedPaths.stream().filter(s -> s.startsWith("META-INF/services")).findAny().isPresent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    @Override
    public Set<String> getExportedPaths() {
        return this.exportedPaths;
    }

    @Override
    public Set<String> getPrivilegedExportedPackages() {
        return this.privilegedExportedPackages;
    }

    @Override
    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }

    public List<ExportedService> getExportedServices() {
        return this.exportedServices != null ? this.exportedServices : Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }
}

