/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.AbstractPipeline;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.construct.FromFlowRejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackPressureStrategySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackPressureStrategySelector.class);
    private static final int EVENT_LOOP_SCHEDULER_BUSY_RETRY_INTERVAL_MS = 2;
    private final AbstractPipeline abstractPipeline;

    public BackPressureStrategySelector(AbstractPipeline abstractPipeline) {
        this.abstractPipeline = abstractPipeline;
    }

    protected void checkWithWaitStrategy(CoreEvent event) throws FlowBackPressureException {
        boolean accepted = false;
        while (!accepted) {
            try {
                this.abstractPipeline.getProcessingStrategy().checkBackpressureAccepting(event);
                accepted = true;
            }
            catch (FromFlowRejectedExecutionException ree) {
                LOGGER.debug("waitStrategy - {} @ {}: {}", new Object[]{ree.getClass().getName(), event.getContext().getOriginatingLocation().getRootContainerName(), ree.getReason()});
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.abstractPipeline.getAlertingSupport().triggerAlert("BACKPRESSURE_TRIGGERED", ree.getReason().name() + " - " + this.abstractPipeline.getName());
                    FlowBackPressureException.createAndThrowIfNeeded(this.abstractPipeline, ree.getReason(), ree);
                }
            }
        }
    }

    protected void checkWithFailDropStrategy(CoreEvent event) throws FlowBackPressureException {
        BackPressureReason reason = this.abstractPipeline.getProcessingStrategy().checkBackpressureEmitting(event);
        if (reason != null) {
            LOGGER.debug("failDropStrategy - @ {}: {}", (Object)event.getContext().getOriginatingLocation().getRootContainerName(), (Object)reason);
            this.abstractPipeline.getAlertingSupport().triggerAlert("BACKPRESSURE_TRIGGERED", reason.name() + " - " + this.abstractPipeline.getName());
            throw this.abstractPipeline.getBackPressureExceptions().get((Object)reason);
        }
    }

    public void check(CoreEvent event) throws FlowBackPressureException {
        if (this.abstractPipeline.getSource().getBackPressureStrategy() == MessageSource.BackPressureStrategy.WAIT) {
            this.checkWithWaitStrategy(event);
        } else {
            this.checkWithFailDropStrategy(event);
        }
    }
}

