/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.module.artifact.activation.internal.classloader.NativeLibraryDependenciesLoader;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.internal.util.FeatureFlaggingUtils;

public class IsolatedNativeLibraryDependenciesLoader
implements NativeLibraryDependenciesLoader {
    public static final String METHOD_NAME = "loadLibrary";
    private static final AtomicBoolean areFeatureFlagsConfigured = new AtomicBoolean();
    private final NativeLibraryFinder nativeLibraryFinder;
    private final boolean supportNativeLibraryDependencies;
    private final LazyValue<Class<?>> dynamicLibraryLoader;

    private static Class<?> getDynamicLibraryLoader(ClassLoader callerClassLoader) {
        return new ByteBuddy().subclass(Object.class).defineMethod(METHOD_NAME, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{String.class}).intercept((Implementation)MethodDelegation.to(System.class)).make().load(callerClassLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    public IsolatedNativeLibraryDependenciesLoader(ArtifactDescriptor artifactDescriptor, NativeLibraryFinder nativeLibraryFinder, ClassLoader artifactClassLoader) {
        this.nativeLibraryFinder = nativeLibraryFinder;
        this.supportNativeLibraryDependencies = FeatureFlaggingUtils.isFeatureEnabled(MuleRuntimeFeature.SUPPORT_NATIVE_LIBRARY_DEPENDENCIES, artifactDescriptor);
        this.dynamicLibraryLoader = new LazyValue<Supplier<Class>>(() -> IsolatedNativeLibraryDependenciesLoader.getDynamicLibraryLoader(artifactClassLoader));
    }

    @Override
    public void loadNativeLibraryDependencies(String nativeLibraryName) {
        if (!this.supportNativeLibraryDependencies) {
            return;
        }
        if (!this.dynamicLibraryLoader.isComputed()) {
            Method method;
            Class<?> loader = this.dynamicLibraryLoader.get();
            try {
                method = loader.getMethod(METHOD_NAME, String.class);
            }
            catch (NoSuchMethodException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create native library loader."), (Throwable)e);
            }
            List<String> nativeLibraries = this.nativeLibraryFinder.findLibraryNames();
            nativeLibraries.remove(nativeLibraryName);
            Collections.reverse(nativeLibraries);
            for (String nativeLibrary : nativeLibraries) {
                try {
                    method.invoke(loader.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), nativeLibrary);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not load %s native library.", nativeLibrary), (Throwable)e);
                }
            }
        }
    }

    private static void configureSupportNativeLibraryDependencies() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.SUPPORT_NATIVE_LIBRARY_DEPENDENCIES, IsolatedNativeLibraryDependenciesLoader.minMuleVersion(MuleVersion.v4_6_0));
    }

    private static Predicate<FeatureContext> minMuleVersion(MuleVersion version) {
        return featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast(version)).isPresent();
    }

    static {
        if (!areFeatureFlagsConfigured.getAndSet(true)) {
            IsolatedNativeLibraryDependenciesLoader.configureSupportNativeLibraryDependencies();
        }
    }
}

