/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.ObjectHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterResolverTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.stereotype.ImplicitStereotypeDefinition;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.extension.internal.semantic.TypeSemanticTermsUtils;
import org.mule.sdk.api.annotation.dsl.xml.TypeDsl;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.sdk.api.runtime.parameter.ParameterResolver;

public class ExtensionObjectTypeHandler
extends ObjectHandler {
    private final ParameterResolverTypeAnnotation parameterResolverTypeAnnotation = new ParameterResolverTypeAnnotation();
    private final LiteralTypeAnnotation literalTypeAnnotation = new LiteralTypeAnnotation();
    private final TypedValueTypeAnnotation typedValueTypeAnnotation = new TypedValueTypeAnnotation();

    public ExtensionObjectTypeHandler(ObjectFieldHandler fieldHandler) {
        super(fieldHandler);
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder baseTypeBuilder) {
        TypeBuilder<MetadataType> typeBuilder = baseTypeBuilder;
        Class<?> currentClass = clazz;
        if (ParameterResolver.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, context.getSubContext(ParameterResolver.class.getName()), baseTypeBuilder, this.parameterResolverTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else if (TypedValue.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, context.getSubContext(TypedValue.class.getName()), baseTypeBuilder, this.typedValueTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else if (Literal.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, context.getSubContext(Literal.class.getName()), baseTypeBuilder, this.literalTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else {
            typeBuilder = super.handleClass(currentClass, genericTypes, typeHandlerManager, context, baseTypeBuilder);
        }
        if (typeBuilder != null && typeBuilder instanceof WithAnnotation) {
            WithAnnotation annotatedBuilder = (WithAnnotation)((Object)typeBuilder);
            if (currentClass.isAnnotationPresent(Extensible.class) || currentClass.isAnnotationPresent(org.mule.sdk.api.annotation.Extensible.class)) {
                annotatedBuilder.with(new ExtensibleTypeAnnotation());
            }
            Optional<TypeDslAnnotation> typeDslAnnotation = this.getTypeDslAnnotation(currentClass);
            typeDslAnnotation.ifPresent(annotatedBuilder::with);
            annotatedBuilder.with(new TypeAliasAnnotation(JavaParserUtils.getAlias(currentClass)));
            boolean allowTopLevelDefinition = typeDslAnnotation.map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
            this.handleStereotype(currentClass, annotatedBuilder, allowTopLevelDefinition);
            TypeSemanticTermsUtils.enrichWithTypeAnnotation(currentClass, annotatedBuilder);
        }
        return typeBuilder;
    }

    private void handleStereotype(Class<?> currentClass, WithAnnotation annotatedBuilder, boolean allowTopLevelDefinition) {
        Optional<StereotypeTypeAnnotation> stereotypeTypeAnnotation = JavaParserUtils.mapReduceAnnotation(currentClass, Stereotype.class, org.mule.sdk.api.annotation.param.stereotype.Stereotype.class, stereotype -> StereotypeTypeAnnotation.fromDefinitions(Collections.singletonList(stereotype.value())), stereotype -> StereotypeTypeAnnotation.fromAllowedDefinitions(Collections.singletonList(stereotype.value())));
        if (stereotypeTypeAnnotation.isPresent()) {
            annotatedBuilder.with(stereotypeTypeAnnotation.get());
        } else if (this.isInterfaceFromThisExtension(currentClass) || allowTopLevelDefinition) {
            annotatedBuilder.with(StereotypeTypeAnnotation.fromDefinitions(Collections.singletonList(ImplicitStereotypeDefinition.class)));
        } else {
            this.calculateInheritedStereotype(currentClass).ifPresent(inh -> annotatedBuilder.with(StereotypeTypeAnnotation.fromDefinitions(Collections.singletonList(inh))));
        }
    }

    private boolean isInterfaceFromThisExtension(Class<?> currentClass) {
        return !currentClass.getName().startsWith("java.") && !currentClass.getName().startsWith("javax.") && !currentClass.getName().startsWith("org.mule.runtime.") && !currentClass.getName().startsWith("com.mulesoft.mule.runtime.") && currentClass.isInterface();
    }

    private Optional<Class<? extends StereotypeDefinition>> calculateInheritedStereotype(Class<?> currentClass) {
        if (currentClass == null) {
            return Optional.empty();
        }
        AtomicReference inheritedStereotype = new AtomicReference();
        Class<?> cls = currentClass;
        for (Class<?> iface : cls.getInterfaces()) {
            this.calculateInheritedStereotype(iface).ifPresent(inheritedStereotype::set);
        }
        while (cls != null && cls.getSuperclass() != Object.class) {
            this.calculateInheritedStereotype(cls.getSuperclass()).ifPresent(inheritedStereotype::set);
            cls = cls.getSuperclass();
        }
        if (inheritedStereotype.get() != null) {
            return Optional.of((Class)inheritedStereotype.get());
        }
        if (currentClass.isAnnotationPresent(Stereotype.class) || currentClass.isAnnotationPresent(org.mule.sdk.api.annotation.param.stereotype.Stereotype.class)) {
            return Optional.of(ImplicitStereotypeDefinition.class);
        }
        return Optional.empty();
    }

    private Class<?> getGenericClass(List<Type> genericTypes, int position) {
        Type type = genericTypes.get(position);
        return type instanceof Class ? (Class)type : Object.class;
    }

    private void handleGenericType(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder, TypeAnnotation annotation) {
        Preconditions.checkArgument(!genericTypes.isEmpty(), String.format("Type %s doesn't have the required generic type", clazz));
        TypeBuilder handle = typeHandlerManager.handle(genericTypes.get(0), context, typeBuilder);
        if (handle instanceof WithAnnotation) {
            ((WithAnnotation)((Object)handle)).with(annotation);
        }
    }

    private Optional<TypeDslAnnotation> getTypeDslAnnotation(Class<?> currentClass) {
        org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl legacyTypeDslAnnotation = currentClass.getAnnotation(org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl.class);
        TypeDsl sdkTypeDslAnnotation = currentClass.getAnnotation(TypeDsl.class);
        Optional<TypeDslAnnotation> typeDslAnnotation = Optional.empty();
        if (legacyTypeDslAnnotation != null && sdkTypeDslAnnotation != null) {
            throw new IllegalModelDefinitionException(String.format("Class '%s' is annotated with '@%s' and '@%s' at the same time", currentClass.getName(), org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl.class.getName(), TypeDsl.class.getName()));
        }
        if (legacyTypeDslAnnotation != null) {
            typeDslAnnotation = Optional.of(new TypeDslAnnotation(legacyTypeDslAnnotation.allowInlineDefinition(), legacyTypeDslAnnotation.allowTopLevelDefinition(), legacyTypeDslAnnotation.substitutionGroup(), legacyTypeDslAnnotation.baseType()));
        } else if (sdkTypeDslAnnotation != null) {
            typeDslAnnotation = Optional.of(new TypeDslAnnotation(sdkTypeDslAnnotation.allowInlineDefinition(), sdkTypeDslAnnotation.allowTopLevelDefinition(), sdkTypeDslAnnotation.substitutionGroup(), sdkTypeDslAnnotation.baseType()));
        }
        return typeDslAnnotation;
    }
}

