/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.resolvers;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;

public class ConfigurationDependencyResolver {
    private final MultiMap<String, String> directComponentDependencies;

    public ConfigurationDependencyResolver(ArtifactAst applicationModel) {
        ArtifactAstDependencyGraph appModelDependencyGraph = ArtifactAstDependencyGraphFactory.generateFor(applicationModel);
        MultiMap dependencies = new MultiMap();
        applicationModel.recursiveStream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).forEach(componentName -> dependencies.put(componentName, appModelDependencyGraph.getRequiredComponents((String)componentName).stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).toList()));
        this.directComponentDependencies = dependencies.toImmutableMultiMap();
    }

    public Collection<String> getDirectComponentDependencies(String componentName) {
        return Objects.requireNonNullElse(this.directComponentDependencies.getAll(componentName), Collections.emptySet());
    }
}

