/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.ref.WeakReference;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.SdkConnectionProviderAdapter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class DefaultConnectionProviderFactory<C>
implements ConnectionProviderFactory<C> {
    private final WeakReference<Class<?>> providerClass;
    private final WeakReference<ClassLoader> extensionClassLoader;

    public DefaultConnectionProviderFactory(Class<?> providerClass, ClassLoader extensionClassLoader) {
        this.extensionClassLoader = new WeakReference<ClassLoader>(extensionClassLoader);
        if (!this.isConnectionProvider(providerClass)) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Class '%s' was specified as a connection provider but it doesn't implement neither the '%s' or '%s' interfaces", providerClass.getName(), ConnectionProvider.class.getName(), org.mule.sdk.api.connectivity.ConnectionProvider.class.getName()));
        }
        IntrospectionUtils.checkInstantiable(providerClass, new ReflectionCache());
        this.providerClass = new WeakReference(providerClass);
    }

    @Override
    public ConnectionProvider<C> newInstance() {
        try {
            return ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader.get(), () -> SdkConnectionProviderAdapter.from(((Class)this.providerClass.get()).newInstance()));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create connection provider of type " + ((Class)this.providerClass.get()).getName()), (Throwable)e);
        }
    }

    @Override
    public Class<? extends ConnectionProvider> getObjectType() {
        Class<SdkConnectionProviderAdapter> type = (Class<SdkConnectionProviderAdapter>)this.providerClass.get();
        if (type == null) {
            return null;
        }
        return ConnectionProvider.class.isAssignableFrom(type) ? type : SdkConnectionProviderAdapter.class;
    }

    private boolean isConnectionProvider(Class<?> providerClass) {
        return ConnectionProvider.class.isAssignableFrom(providerClass) || org.mule.sdk.api.connectivity.ConnectionProvider.class.isAssignableFrom(providerClass);
    }
}

