/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.connection;

import jakarta.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.registry.InjectionTargetDecorator;
import org.mule.sdk.api.connectivity.CachedConnectionProvider;
import org.mule.sdk.api.connectivity.ConnectionValidationResult;
import org.mule.sdk.api.connectivity.PoolingConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseSdkConnectionProviderAdapter<C>
implements org.mule.sdk.api.connectivity.ConnectionProvider<C>,
Lifecycle,
MuleContextAware,
InjectionTargetDecorator<ConnectionProvider<C>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReverseSdkConnectionProviderAdapter.class);
    private final ConnectionProvider<C> delegate;
    @Inject
    private MuleContext muleContext;

    public static <C> org.mule.sdk.api.connectivity.ConnectionProvider<C> from(Object connectionProvider) {
        if (connectionProvider != null) {
            if (connectionProvider instanceof org.mule.sdk.api.connectivity.ConnectionProvider) {
                return (org.mule.sdk.api.connectivity.ConnectionProvider)connectionProvider;
            }
            if (connectionProvider instanceof org.mule.runtime.api.connection.CachedConnectionProvider) {
                return new SdkCachedConnectionProviderAdapter((org.mule.runtime.api.connection.CachedConnectionProvider)connectionProvider);
            }
            if (connectionProvider instanceof org.mule.runtime.api.connection.PoolingConnectionProvider) {
                return new SdkPoolingConnectionProviderAdapter((org.mule.runtime.api.connection.PoolingConnectionProvider)connectionProvider);
            }
            if (connectionProvider instanceof ConnectionProvider) {
                return new ReverseSdkConnectionProviderAdapter<C>((ConnectionProvider)connectionProvider);
            }
            throw new IllegalArgumentException("Unsupported ConnectionProvider type " + connectionProvider.getClass().getName());
        }
        throw new IllegalArgumentException("connectionProvider cannot be null");
    }

    private ReverseSdkConnectionProviderAdapter(ConnectionProvider<C> delegate) {
        this.delegate = delegate;
    }

    @Override
    public C connect() throws ConnectionException {
        return this.delegate.connect();
    }

    @Override
    public void disconnect(C connection) {
        this.delegate.disconnect(connection);
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        return this.adapt(this.delegate.validate(connection));
    }

    @Override
    public ConnectionProvider<C> getDelegate() {
        return this.delegate;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.muleContext != null) {
            LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
        } else {
            LifecycleUtils.initialiseIfNeeded(this.delegate);
        }
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.delegate instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.delegate)).setMuleContext(this.muleContext);
        }
    }

    private ConnectionValidationResult adapt(org.mule.runtime.api.connection.ConnectionValidationResult result) {
        return result.isValid() ? ConnectionValidationResult.success() : ConnectionValidationResult.failure(result.getMessage(), result.getErrorType().orElse(null), result.getException());
    }

    private static class SdkCachedConnectionProviderAdapter<C>
    extends ReverseSdkConnectionProviderAdapter<C>
    implements CachedConnectionProvider<C> {
        private SdkCachedConnectionProviderAdapter(org.mule.runtime.api.connection.CachedConnectionProvider<C> delegate) {
            super(delegate);
        }
    }

    private static class SdkPoolingConnectionProviderAdapter<C>
    extends ReverseSdkConnectionProviderAdapter<C>
    implements PoolingConnectionProvider<C> {
        private final org.mule.runtime.api.connection.PoolingConnectionProvider<C> delegate;

        private SdkPoolingConnectionProviderAdapter(org.mule.runtime.api.connection.PoolingConnectionProvider<C> delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void onBorrow(C connection) {
            this.delegate.onBorrow(connection);
        }

        @Override
        public void onReturn(C connection) {
            this.delegate.onReturn(connection);
        }
    }
}

