/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.core.internal.util.func.CheckedSupplier;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;

public class ObjectProviderAwareBeanFactory
extends DefaultListableBeanFactory {
    private List<ConfigurableObjectProvider> objectProviders = Collections.emptyList();

    public ObjectProviderAwareBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setObjectProviders(List<ConfigurableObjectProvider> objectProviders) {
        this.objectProviders = objectProviders;
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        boolean doNotFail = false;
        try {
            Object bean = super.getBean(requiredType);
            if (bean == null) {
                doNotFail = true;
                throw new NoSuchBeanDefinitionException(requiredType);
            }
            return (T)bean;
        }
        catch (NoSuchBeanDefinitionException e) {
            Optional<Object> objectFound = this.objectProviders.stream().map(objectProvider -> objectProvider.getObjectByType(requiredType)).filter(valueOptional -> valueOptional.isPresent()).map(valueOptional -> valueOptional.get()).findFirst();
            return (T)(doNotFail ? null : objectFound.orElseThrow(() -> e));
        }
    }

    public Object getBean(String name) throws BeansException {
        boolean doNotFail = false;
        try {
            Object bean = super.getBean(name);
            if (bean == null) {
                doNotFail = true;
                throw new NoSuchBeanDefinitionException(name);
            }
            return bean;
        }
        catch (BeanCreationException e) {
            throw this.unwrapBeanCreationException(e);
        }
        catch (NoSuchBeanDefinitionException e) {
            Optional<Object> objectFound = this.objectProviders.stream().map(objectProvider -> objectProvider.getObject(name)).filter(valueOptional -> valueOptional.isPresent()).map(valueOptional -> valueOptional.get()).findFirst();
            return doNotFail ? null : objectFound.orElseThrow(() -> e);
        }
    }

    private BeanCreationException unwrapBeanCreationException(BeanCreationException beanCreationException) {
        Throwable currentCause;
        StringBuilder messageBuilder = new StringBuilder();
        for (currentCause = beanCreationException; currentCause != null && currentCause instanceof BeanCreationException; currentCause = currentCause.getCause()) {
            if (messageBuilder.length() > 0) {
                messageBuilder.append("; nested exception is ");
            }
            messageBuilder.append(currentCause.getMessage());
        }
        if (currentCause != null) {
            if (messageBuilder.length() > 0) {
                messageBuilder.append("; nested exception is ");
            }
            messageBuilder.append(currentCause.getMessage());
        }
        return new BeanCreationException(messageBuilder.toString(), (Throwable)beanCreationException);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.doWithFallbackInObjectProvider(() -> super.isSingleton(name), objectProvider -> {
            try {
                return objectProvider.isObjectSingleton(name);
            }
            catch (NoSuchBeanDefinitionException e) {
                return Optional.empty();
            }
        }).orElse(false);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        HashMap<String, T> beans = new HashMap<String, T>();
        for (ObjectProvider objectProvider : this.objectProviders) {
            beans.putAll(objectProvider.getObjectsByType(type));
        }
        beans.putAll(super.getBeansOfType(type));
        return Collections.unmodifiableMap(beans);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        HashMap<String, T> beans = new HashMap<String, T>();
        for (ObjectProvider objectProvider : this.objectProviders) {
            beans.putAll(objectProvider.getObjectsByType(type));
        }
        beans.putAll(super.getBeansOfType(type, includeNonSingletons, allowEagerInit));
        return Collections.unmodifiableMap(beans);
    }

    protected Class<?> determineTargetType(String beanName, RootBeanDefinition mbd, Class<?> ... typesToMatch) {
        Object value;
        if (mbd.getBeanClass().equals(ConstantFactoryBean.class) && (value = mbd.getConstructorArgumentValues().getArgumentValue(0, Object.class).getValue()) != null) {
            return value.getClass();
        }
        return super.determineTargetType(beanName, mbd, (Class[])typesToMatch);
    }

    public void autowireBean(Object existingBean) {
        RootBeanDefinition bd = new RootBeanDefinition(ClassUtils.getUserClass((Object)existingBean));
        bd.setScope("prototype");
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper((BeanWrapper)bw);
        this.populateBean(bd.getBeanClass().getName(), bd, (BeanWrapper)bw);
    }

    public <T> Map<String, T> getBeansOfTypeWithObjectProviderObjects(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return super.getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    private <T> Optional<T> doWithFallbackInObjectProvider(CheckedSupplier<T> thisSupplier, Function<ObjectProvider, Optional<T>> fallbackFunction) throws BeansException {
        try {
            return Optional.of(thisSupplier.get());
        }
        catch (Exception e) {
            try {
                Optional<Optional> firstValue = this.objectProviders.stream().map(objectProvider -> (Optional)fallbackFunction.apply((ObjectProvider)objectProvider)).filter(Optional::isPresent).findFirst();
                return firstValue.orElseThrow(() -> e);
            }
            catch (BeansException beansException) {
                throw beansException;
            }
            catch (Exception e2) {
                throw new MuleRuntimeException(e2);
            }
        }
    }
}

