/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.lifecycle;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.slf4j.Logger;

public class LifecycleUtils {
    private LifecycleUtils() {
    }

    public static void initialiseIfNeeded(Object object) throws InitialisationException {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Initialisable) {
            ((Initialisable)object).initialise();
        }
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static void initialiseIfNeeded(Object object, MuleContext muleContext) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(object, true, muleContext);
    }

    public static void initialiseIfNeeded(Object object, Injector injector) throws InitialisationException {
        Objects.requireNonNull(injector, "injector cannot be null");
        object = LifecycleUtils.unwrap(object);
        if (object == null) {
            return;
        }
        LifecycleUtils.doInject(object, injector);
        LifecycleUtils.initialiseIfNeeded(object);
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static void initialiseIfNeeded(Object object, boolean inject, MuleContext muleContext) throws InitialisationException {
        Objects.requireNonNull(muleContext, "muleContext cannot be null");
        object = LifecycleUtils.setMuleContextIfNeededFluent(object, muleContext);
        if (inject) {
            Injector injector = muleContext.getInjector();
            LifecycleUtils.initialiseIfNeeded(object, injector);
        } else {
            LifecycleUtils.initialiseIfNeeded(object);
        }
    }

    private static void doInject(Object object, Injector injector) throws InitialisationException {
        try {
            injector.inject(object);
        }
        catch (MuleException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage(String.format("Found exception trying to inject object of type '%s' on initialising phase", object.getClass().getName()));
            if (object instanceof Initialisable) {
                Initialisable initialisable = (Initialisable)object;
                throw new InitialisationException(message, (Throwable)e, initialisable);
            }
            throw new MuleRuntimeException(message, (Throwable)e);
        }
    }

    public static void initialiseIfNeeded(Collection<? extends Object> objects) throws InitialisationException {
        for (Object object : objects) {
            LifecycleUtils.initialiseIfNeeded(object);
        }
    }

    public static void initialiseIfNeeded(Collection<? extends Object> objects, Injector injector) throws InitialisationException {
        for (Object object : objects) {
            LifecycleUtils.initialiseIfNeeded(object, injector);
        }
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static void initialiseIfNeeded(Collection<? extends Object> objects, MuleContext muleContext) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(objects, true, muleContext);
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static void initialiseIfNeeded(Collection<? extends Object> objects, boolean inject, MuleContext muleContext) throws InitialisationException {
        for (Object object : objects) {
            LifecycleUtils.initialiseIfNeeded(object, inject, muleContext);
        }
    }

    public static void startIfNeeded(Object object) throws MuleException {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Startable) {
            Startable startable = (Startable)object;
            startable.start();
        }
    }

    public static void startIfNeeded(Collection<? extends Object> objects) throws MuleException {
        LifecycleUtils.doApplyPhase("start", objects, null, null);
    }

    public static void stopIfNeeded(Collection<? extends Object> objects) throws MuleException {
        LifecycleUtils.doApplyPhase("stop", objects, null, null);
    }

    public static void safeStopIfNeeded(Collection<? extends Object> objects, Logger logger) {
        try {
            LifecycleUtils.doApplyPhase("stop", objects, null, logger);
        }
        catch (Exception e) {
            logger.warn("Found unexpected exception during safe stop", (Throwable)e);
        }
    }

    public static void stopIfNeeded(Object object) throws MuleException {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Stoppable) {
            Stoppable stoppable = (Stoppable)object;
            stoppable.stop();
        }
    }

    public static void disposeIfNeeded(Object object, Logger logger) {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Disposable) {
            Disposable disposable = (Disposable)object;
            try {
                disposable.dispose();
            }
            catch (Exception e) {
                if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                    throw e;
                }
                logger.error("Exception found trying to dispose object. Shutdown will continue", (Throwable)e);
            }
        }
    }

    public static void disposeIfNeeded(Collection<? extends Object> objects, Logger logger) {
        try {
            LifecycleUtils.doApplyPhase("dispose", objects, null, logger);
        }
        catch (Exception e) {
            logger.error("Exception found trying to dispose object. Shutdown will continue", (Throwable)e);
        }
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static void assertNotStopping(MuleContext muleContext, String errorMessage) {
        if (muleContext.isStopping() || muleContext.isStopped() && !muleContext.isStarting()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void assertNotStopping(LifecycleState deploymentLifecycleState, String errorMessage) {
        if (deploymentLifecycleState.isStopping() || deploymentLifecycleState.isStopped() && !deploymentLifecycleState.isStarting()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    @Deprecated
    public static boolean isLazyInitMode(ConfigurationProperties properties) {
        return properties != null && properties.resolveBooleanProperty("mule.application.deployment.lazyInit").orElse(false) != false;
    }

    @Deprecated
    public static boolean isDslDeclarationValidationEnabled(ConfigurationProperties properties) {
        return properties != null && properties.resolveBooleanProperty("mule.application.deployment.lazyInit.enableDslDeclarationValidations").orElse(false) != false;
    }

    public static Object setMuleContextIfNeededFluent(Object object, MuleContext muleContext) {
        if ((object = LifecycleUtils.unwrap(object)) != null && object instanceof MuleContextAware) {
            MuleContextAware mca = (MuleContextAware)object;
            mca.setMuleContext(muleContext);
        }
        return object;
    }

    public static void setMuleContextIfNeeded(Object object, MuleContext muleContext) {
        if ((object = LifecycleUtils.unwrap(object)) != null && object instanceof MuleContextAware) {
            MuleContextAware mca = (MuleContextAware)object;
            mca.setMuleContext(muleContext);
        }
    }

    public static void setMuleContextIfNeeded(Collection<? extends Object> objects, MuleContext muleContext) {
        objects.forEach(o -> LifecycleUtils.setMuleContextIfNeeded(o, muleContext));
    }

    private static void doApplyPhase(String phase, Collection<? extends Object> objects, MuleContext muleContext, Logger logger) throws MuleException {
        for (Object object : objects) {
            Object object2 = LifecycleUtils.unwrap(object);
            if (object2 == null) continue;
            try {
                if ("initialise".equals(phase)) {
                    if (muleContext != null) {
                        LifecycleUtils.initialiseIfNeeded(object2, muleContext);
                        continue;
                    }
                    LifecycleUtils.initialiseIfNeeded(object2);
                    continue;
                }
                if ("start".equals(phase)) {
                    LifecycleUtils.startIfNeeded(object2);
                    continue;
                }
                if ("stop".equals(phase)) {
                    LifecycleUtils.stopIfNeeded(object2);
                    continue;
                }
                if (!"dispose".equals(phase) || !(object2 instanceof Disposable)) continue;
                LifecycleUtils.disposeIfNeeded(object2, logger);
            }
            catch (MuleException e) {
                if (logger != null) {
                    logger.error(String.format("Could not apply %s phase on object of class %s", phase, object2.getClass().getName()), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static Object unwrap(Object value) {
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            return opt.orElse(null);
        }
        return value;
    }
}

