/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.function;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.function.FunctionExecutor;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveExpressionFunctionExecutor
implements Lifecycle,
FunctionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveExpressionFunctionExecutor.class);
    private final Method method;
    private final FunctionModel model;
    private final DataType returnType;
    private final Object componentInstance;
    private final ClassLoader extensionClassLoader;
    private final List<FunctionParameter> functionParameters;
    private final Function<Object[], Object[]> parametersResolver;
    @Inject
    private MuleContext muleContext;
    @Inject
    private TransformationService transformationService;

    public ReflectiveExpressionFunctionExecutor(FunctionModel model, DataType returnType, List<FunctionParameter> functionParameters, Method method, Object componentInstance) {
        this.model = model;
        this.method = method;
        this.returnType = returnType;
        this.componentInstance = componentInstance;
        this.functionParameters = functionParameters;
        this.extensionClassLoader = method.getDeclaringClass().getClassLoader();
        this.parametersResolver = this.getTypedValueArgumentsResolver(method);
    }

    @Override
    public Object call(Object[] parameters, BindingContext context) {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.extensionClassLoader);
        Object[] target = this.parametersResolver.apply(parameters);
        try {
            Object object = this.method.invoke(this.componentInstance, target);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw new MuleRuntimeException(ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.extensionClassLoader, currentClassLoader);
        }
    }

    @Override
    public Optional<DataType> returnType() {
        return Optional.ofNullable(this.returnType);
    }

    @Override
    public List<FunctionParameter> parameters() {
        return this.functionParameters;
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.componentInstance, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.componentInstance);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.componentInstance);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.componentInstance, LOGGER);
    }

    private Function<Object[], Object[]> getTypedValueArgumentsResolver(Method method) {
        Parameter[] parameters = method.getParameters();
        Function[] resolvers = new Function[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<?> type = parameter.getType();
            resolvers[i] = TypedValue.class.isAssignableFrom(type) ? this.getWrapper(parameter) : this.getUnWrapper(type);
        }
        return args -> {
            if (args == null) {
                return null;
            }
            if (((Object[])args).length == 0) {
                return args;
            }
            Object[] values = new Object[((Object[])args).length];
            for (int i = 0; i < ((Object[])args).length; ++i) {
                values[i] = resolvers[i].apply(args[i]);
            }
            return values;
        };
    }

    private Function<Object, Object> getWrapper(Parameter parameter) {
        Type[] generics = parameter.getType().getGenericInterfaces();
        Class type = generics.length == 0 ? Object.class : this.model.getAllParameterModels().stream().filter(p -> p.getModelProperty(ImplementingParameterModelProperty.class).map(mp -> mp.getParameter().getName().equals(parameter.getName())).orElse(false)).map(p -> ExtensionMetadataTypeUtils.getType(p.getType()).orElse(Object.class)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Missing parameter with name [%s]", parameter.getName())));
        DataType expected = DataType.fromType(type);
        return value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof TypedValue) {
                TypedValue typedValue;
                if (((TypedValue)value).getDataType().equals(DataType.TYPED_VALUE)) {
                    value = ((TypedValue)value).getValue();
                }
                return type.isInstance((typedValue = (TypedValue)value).getValue()) ? value : new TypedValue<Object>(this.transformationService.transform(typedValue.getValue(), typedValue.getDataType(), expected), typedValue.getDataType());
            }
            return new TypedValue<Object>(value, DataType.fromObject(value));
        };
    }

    private Function<Object, Object> getUnWrapper(Class<?> parameterType) {
        DataType expected = DataType.fromType(parameterType);
        return value -> this.doUnWrap(value, expected);
    }

    private Object doUnWrap(Object value, DataType expected) {
        return value instanceof TypedValue ? this.doUnWrap(((TypedValue)value).getValue(), expected) : (ClassUtils.isInstance(expected.getType(), value) ? value : this.transformationService.transform(value, DataType.fromObject(value), expected));
    }
}

