/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.tooling.valueprovider.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldsValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.FieldValueProviderNameUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderFactoryWrapper;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;

public final class DefaultValueProviderMediator<T extends ParameterizedModel & EnrichableModel>
implements ValueProviderMediator {
    private final T containerModel;
    private final Supplier<MuleContext> muleContext;
    private final Supplier<Object> nullSupplier = () -> null;

    public DefaultValueProviderMediator(T containerModel, Supplier<MuleContext> muleContext, Supplier<ReflectionCache> reflectionCache) {
        this.containerModel = containerModel;
        this.muleContext = muleContext;
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver) throws ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, this.nullSupplier, this.nullSupplier);
    }

    public Set<Value> getValues(String parameterName, String targetSelector, ParameterValueResolver parameterValueResolver) throws ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, targetSelector, this.nullSupplier, this.nullSupplier);
    }

    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, connectionSupplier, configurationSupplier, null);
    }

    @Override
    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, String targetSelector, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) throws ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, targetSelector, connectionSupplier, configurationSupplier, null);
    }

    @Override
    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, ConnectionProvider connectionProvider) throws ValueResolvingException {
        return this.getValues(parameterName, parameterValueResolver, null, connectionSupplier, configurationSupplier, connectionProvider);
    }

    @Override
    public Set<Value> getValues(String parameterName, ParameterValueResolver parameterValueResolver, String targetSelector, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, ConnectionProvider connectionProvider) throws ValueResolvingException {
        ValueProviderModel valueProviderModel;
        ValueProviderFactoryModelProperty factoryModelProperty;
        List<ParameterModel> parameters = this.getParameters(parameterName);
        if (parameters.isEmpty()) {
            throw new ValueResolvingException(String.format("Unable to find model for parameter or parameter group with name '%s'.", parameterName), "INVALID_VALUE_RESOLVER_NAME");
        }
        ParameterModel parameterModel = parameters.get(0);
        if (targetSelector != null) {
            factoryModelProperty = parameterModel.getModelProperty(FieldsValueProviderFactoryModelProperty.class).map(fieldsValueProvider -> fieldsValueProvider.getFieldsValueProviderFactories().get(targetSelector)).orElseThrow(() -> new ValueResolvingException(String.format("The parameter with name '%s' does not have a Value Provider associated with the targetSelector '%s'", parameterName, targetSelector), "INVALID_VALUE_RESOLVER_NAME"));
            valueProviderModel = parameterModel.getFieldValueProviderModels().stream().filter(fvpm -> fvpm.getTargetSelector().equals(targetSelector)).findFirst().get();
        } else {
            factoryModelProperty = parameterModel.getModelProperty(ValueProviderFactoryModelProperty.class).orElseThrow(() -> new ValueResolvingException(String.format("The parameter with name '%s' is not an Values Provider", parameterName), "INVALID_VALUE_RESOLVER_NAME"));
            valueProviderModel = parameterModel.getValueProviderModel().get();
        }
        try {
            return ExtensionsOAuthUtils.withRefreshToken(connectionProvider, () -> this.resolveValues(parameters, valueProviderModel, factoryModelProperty, parameterValueResolver, connectionSupplier, configurationSupplier, targetSelector));
        }
        catch (ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueResolvingException(String.format("An error occurred trying to resolve the Values for parameter '%s' of component '%s'. Cause: %s", parameterName, this.containerModel.getName(), e.getMessage()), "UNKNOWN", (Throwable)e);
        }
    }

    private Set<Value> resolveValues(List<ParameterModel> parameters, ValueProviderModel valueProviderModel, ValueProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, String targetSelector) throws ValueResolvingException {
        ValueProviderFactoryWrapper valueProviderFactoryWrapper = new ValueProviderFactoryWrapper(valueProviderModel, factoryModelProperty.getFactory(), parameterValueResolver, connectionSupplier, configurationSupplier, this.muleContext.get(), (ParameterizedModel)this.containerModel);
        ValueProvider valueProvider = valueProviderFactoryWrapper.createValueProvider();
        Set<Value> valueSet = valueProvider.resolve();
        return valueSet.stream().map(option -> ValueProviderUtils.cloneAndEnrichValue(option, parameters, valueProvider.getId(), targetSelector)).map(ValueBuilder::build).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<ParameterModel> getParameters(String valueName) {
        ArrayList<ParameterModel> parameterModels = new ArrayList<ParameterModel>();
        for (ParameterModel parameterModel : this.containerModel.getAllParameterModels()) {
            if (parameterModel.getValueProviderModel().isPresent() && parameterModel.getValueProviderModel().get().getProviderName().equals(valueName)) {
                parameterModels.add(parameterModel);
                continue;
            }
            if (!parameterModel.getFieldValueProviderModels().stream().anyMatch(fieldValueProviderModel -> FieldValueProviderNameUtils.getParameterName(fieldValueProviderModel).equals(valueName))) continue;
            parameterModels.add(parameterModel);
        }
        return parameterModels;
    }
}

