/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.IdentifierParsingUtils;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.error.MuleCoreErrorTypeRepository;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkErrorModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.utils.Characteristic;

public class AggregatedErrorsCharacteristic
extends Characteristic<List<ErrorModelParser>> {
    private static final String CORE_ERROR_NAMESPACE = "mule".toUpperCase(Locale.getDefault());
    private static final String ERROR_TYPE_PARAM = "type";
    private static final String WHEN_PARAM = "when";
    private static final ComponentIdentifier RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("operation").name("raise-error").build();

    public AggregatedErrorsCharacteristic(String namespace) {
        super(new Aggregator(namespace), Collections.emptyList(), null);
    }

    private static class Aggregator
    implements BiFunction<Characteristic.ComponentAstWithHierarchy, List<ErrorModelParser>, List<ErrorModelParser>> {
        private final String namespace;

        private Aggregator(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public List<ErrorModelParser> apply(Characteristic.ComponentAstWithHierarchy componentAstWithHierarchy, List<ErrorModelParser> errorModels) {
            List<ErrorModelParser> models = errorModels;
            if (models == null) {
                models = new ArrayList<ErrorModelParser>(5);
            }
            ComponentAst operationAst = componentAstWithHierarchy.getComponentAst();
            List<ComponentAst> hierarchy = componentAstWithHierarchy.getHierarchy();
            if (Aggregator.isRaiseError(operationAst)) {
                this.handleRaiseError(operationAst, models, hierarchy);
            } else {
                this.handleOperationOtherThanRaiseError(operationAst, models, hierarchy);
            }
            return models;
        }

        private void handleOperationOtherThanRaiseError(ComponentAst operationAst, List<ErrorModelParser> models, List<ComponentAst> hierarchy) {
            Optional<OperationModel> operationModel = operationAst.getModel(OperationModel.class);
            operationModel.ifPresent(model -> model.getErrorModels().stream().map(errorModel -> this.applyMappingsAndCreateErrorModelParser((ErrorModel)errorModel, operationAst)).forEach(errorModelParser -> this.addParserAndMarkIfSuppressed((MuleSdkErrorModelParser)errorModelParser, models, hierarchy)));
        }

        private MuleSdkErrorModelParser applyMappingsAndCreateErrorModelParser(ErrorModel errorModel, ComponentAst operationAst) {
            ComponentParameterAst errorMappingsParam = operationAst.getParameter("Error Mappings", "errorMappings");
            if (errorMappingsParam == null) {
                return this.createErrorModelParser(errorModel);
            }
            Optional errorMappingsOpt = errorMappingsParam.getValue().getValue();
            if (!errorMappingsOpt.isPresent()) {
                return this.createErrorModelParser(errorModel);
            }
            List errorMappings = (List)errorMappingsOpt.get();
            return this.applyMappingIfSomeMatches(errorModel, errorMappings);
        }

        private MuleSdkErrorModelParser createErrorModelParser(ErrorModel errorModel) {
            return new MuleSdkErrorModelParser(errorModel);
        }

        private MuleSdkErrorModelParser applyMappingIfSomeMatches(ErrorModel errorModel, List<ErrorMapping> errorMappings) {
            return errorMappings.stream().filter(errorMapping -> this.doesMappingSourceMatch((ErrorMapping)errorMapping, errorModel)).map(Aggregator::buildParserFromTarget).findFirst().orElseGet(() -> this.createErrorModelParser(errorModel));
        }

        private static MuleSdkErrorModelParser buildParserFromTarget(ErrorMapping errorMapping) {
            String mappingTargetAsString = errorMapping.getTarget();
            ComponentIdentifier targetErrorId = IdentifierParsingUtils.parseErrorType(mappingTargetAsString, CORE_ERROR_NAMESPACE);
            if (CORE_ERROR_NAMESPACE.equals(targetErrorId.getNamespace())) {
                return new MuleSdkErrorModelParser(MuleCoreErrorTypeRepository.MULE_CORE_ERROR_TYPE_REPOSITORY.getErrorType(targetErrorId).orElseThrow(() -> new IllegalArgumentException(String.format("Error doesn't exist %s", targetErrorId))));
            }
            return new MuleSdkErrorModelParser(targetErrorId.getNamespace(), targetErrorId.getName(), null);
        }

        private boolean doesMappingSourceMatch(ErrorMapping errorMapping, ErrorModel errorModel) {
            String mappingSourceAsString = errorMapping.getSource();
            ComponentIdentifier sourceErrorId = IdentifierParsingUtils.parseErrorType(mappingSourceAsString, CORE_ERROR_NAMESPACE);
            return new SingleErrorModelParserMatcher(sourceErrorId).matches(this.createErrorModelParser(errorModel));
        }

        private void handleRaiseError(ComponentAst raiseErrorAst, List<ErrorModelParser> errorModels, List<ComponentAst> hierarchy) {
            ComponentParameterAst typeParameter = raiseErrorAst.getParameter("General", AggregatedErrorsCharacteristic.ERROR_TYPE_PARAM);
            if (null == typeParameter) {
                return;
            }
            Optional errorId = typeParameter.getValue().getValue();
            if (!errorId.isPresent()) {
                return;
            }
            this.addParserAndMarkIfSuppressed(new MuleSdkErrorModelParser(this.namespace, (String)errorId.get(), null), errorModels, hierarchy);
        }

        private static boolean isRaiseError(ComponentAst operationAst) {
            return operationAst.getIdentifier().equals(RAISE_ERROR_IDENTIFIER);
        }

        private void addParserAndMarkIfSuppressed(MuleSdkErrorModelParser errorModelParser, List<ErrorModelParser> models, List<ComponentAst> hierarchy) {
            List<ErrorModelParserMatcher> suppressedErrors = this.getSuppressedErrors(hierarchy);
            if (this.isErrorSuppressed(errorModelParser, suppressedErrors)) {
                errorModelParser.setSuppressed();
            }
            models.add(errorModelParser);
        }

        private List<ErrorModelParserMatcher> getSuppressedErrors(List<ComponentAst> hierarchy) {
            if (hierarchy.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ErrorModelParserMatcher> suppressedErrors = new ArrayList<ErrorModelParserMatcher>();
            for (int containerIndex = hierarchy.size() - 1; containerIndex >= 0; --containerIndex) {
                ComponentAst container = hierarchy.get(containerIndex);
                if (container.getIdentifier().equals(CoreDslConstants.TRY_IDENTIFIER)) {
                    this.addSuppressedErrors(container, suppressedErrors);
                    continue;
                }
                if (!container.getIdentifier().equals(CoreDslConstants.ERROR_HANDLER_IDENTIFIER)) continue;
                --containerIndex;
            }
            return suppressedErrors;
        }

        private void addSuppressedErrors(ComponentAst tryScopeAst, List<ErrorModelParserMatcher> suppressedErrors) {
            Optional<ComponentAst> errorHandler = tryScopeAst.directChildrenStreamByIdentifier("mule", "error-handler").findFirst();
            if (!errorHandler.isPresent()) {
                return;
            }
            errorHandler.get().directChildrenStreamByIdentifier("mule", "on-error-continue").filter(onErrorContinue -> !onErrorContinue.getParameter("General", AggregatedErrorsCharacteristic.WHEN_PARAM).getValue().getValue().isPresent()).forEach(onErrorContinue -> {
                String typeAsString = onErrorContinue.getParameter("General", AggregatedErrorsCharacteristic.ERROR_TYPE_PARAM).getValue().getValue().orElse(null);
                suppressedErrors.add(Aggregator.createErrorModelParserMatcher(typeAsString));
            });
        }

        private boolean isErrorSuppressed(ErrorModelParser errorModelParser, List<ErrorModelParserMatcher> suppressedErrors) {
            return suppressedErrors.stream().anyMatch(matcher -> matcher.matches(errorModelParser));
        }

        private static ErrorModelParserMatcher createErrorModelParserMatcher(String typesAsString) {
            if (typesAsString == null) {
                return ErrorModelParserMatcher.ANY_ERROR_PARSER_MATCHER;
            }
            String[] errorTypeIdentifiers = typesAsString.split(",");
            List<ErrorModelParserMatcher> matchers = Arrays.stream(errorTypeIdentifiers).map(identifier -> {
                String parsedIdentifier = identifier.trim();
                ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation(parsedIdentifier);
                if (Aggregator.doesErrorTypeContainWildcards(errorTypeComponentIdentifier)) {
                    return new WildcardErrorModelParserMatcher(errorTypeComponentIdentifier);
                }
                return new SingleErrorModelParserMatcher(errorTypeComponentIdentifier);
            }).collect(Collectors.toList());
            return new DisjunctiveErrorModelParserMatcher(matchers);
        }

        private static boolean doesErrorTypeContainWildcards(ComponentIdentifier errorTypeIdentifier) {
            if (errorTypeIdentifier == null) {
                return false;
            }
            if (Objects.equals("*", errorTypeIdentifier.getName())) {
                return true;
            }
            return Objects.equals("*", errorTypeIdentifier.getNamespace());
        }
    }

    private static final class DisjunctiveErrorModelParserMatcher
    implements ErrorModelParserMatcher {
        private final List<ErrorModelParserMatcher> matchers;

        private DisjunctiveErrorModelParserMatcher(List<ErrorModelParserMatcher> matchers) {
            this.matchers = new CopyOnWriteArrayList<ErrorModelParserMatcher>(matchers);
        }

        @Override
        public boolean matches(ErrorModelParser errorModelParser) {
            for (ErrorModelParserMatcher matcher : this.matchers) {
                if (!matcher.matches(errorModelParser)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SingleErrorModelParserMatcher
    implements ErrorModelParserMatcher {
        private final ComponentIdentifier errorIdentifier;

        private SingleErrorModelParserMatcher(ComponentIdentifier errorIdentifier) {
            this.errorIdentifier = errorIdentifier;
        }

        @Override
        public boolean matches(ErrorModelParser errorModelParser) {
            return this.matchIdentifier(errorModelParser) && this.matchNamespace(errorModelParser) || this.isChild(errorModelParser);
        }

        private boolean matchNamespace(ErrorModelParser errorModelParser) {
            return Objects.equals(this.errorIdentifier.getNamespace(), errorModelParser.getNamespace());
        }

        private boolean matchIdentifier(ErrorModelParser errorModelParser) {
            return Objects.equals(this.errorIdentifier.getName(), errorModelParser.getType());
        }

        private boolean isChild(ErrorModelParser errorModelParser) {
            Optional<ErrorModelParser> parentErrorType = errorModelParser.getParent();
            return parentErrorType.isPresent() && this.matches(parentErrorType.get());
        }
    }

    private static final class WildcardErrorModelParserMatcher
    implements ErrorModelParserMatcher {
        public static final String WILDCARD_TOKEN = "*";
        private final ComponentIdentifier errorIdentifier;
        private final boolean nameIsWildcard;
        private final boolean namespaceIsWildcard;

        private WildcardErrorModelParserMatcher(ComponentIdentifier errorIdentifier) {
            this.errorIdentifier = errorIdentifier;
            this.nameIsWildcard = WILDCARD_TOKEN.equals(errorIdentifier.getName());
            this.namespaceIsWildcard = WILDCARD_TOKEN.equals(errorIdentifier.getNamespace());
        }

        @Override
        public boolean matches(ErrorModelParser errorModelParser) {
            if (this.matchIdentifier(errorModelParser) && this.matchNamespace(errorModelParser)) {
                return true;
            }
            return !this.nameIsWildcard && this.isChild(errorModelParser);
        }

        private boolean matchNamespace(ErrorModelParser errorModelParser) {
            if (this.namespaceIsWildcard) {
                return true;
            }
            return Objects.equals(this.errorIdentifier.getNamespace(), errorModelParser.getNamespace());
        }

        private boolean matchIdentifier(ErrorModelParser errorModelParser) {
            if (this.nameIsWildcard) {
                return true;
            }
            return Objects.equals(this.errorIdentifier.getName(), errorModelParser.getType());
        }

        private boolean isChild(ErrorModelParser errorModelParser) {
            Optional<ErrorModelParser> parentErrorType = errorModelParser.getParent();
            return parentErrorType.isPresent() && this.matches(parentErrorType.get());
        }
    }

    private static class AnyErrorModelParserMatcher
    implements ErrorModelParserMatcher {
        private AnyErrorModelParserMatcher() {
        }

        @Override
        public boolean matches(ErrorModelParser errorModelParser) {
            return true;
        }
    }

    private static interface ErrorModelParserMatcher {
        public static final ErrorModelParserMatcher ANY_ERROR_PARSER_MATCHER = new AnyErrorModelParserMatcher();

        public boolean matches(ErrorModelParser var1);
    }
}

