/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.container.internal.splash.SimpleLoggingTable;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentStatusTracker;
import org.mule.runtime.module.deployment.internal.DeploymentStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupSummaryDeploymentListener
implements StartupListener {
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    private static final String APPLICATION_LABEL = "APPLICATION";
    private static final String DOMAIN_OWNER_LABEL = "DOMAIN";
    private static final String STATUS_LABEL = "STATUS";
    private static final int ARTIFACT_NAME_LABEL_LENGTH = 45;
    private static final int STATUS_LABEL_LENGTH = 18;
    private static final int DOMAIN_OWNER_LABEL_LENGTH = 30;
    private static final String UNKNOWN_ARTIFACT_NAME = "UNKNOWN";
    private final DeploymentService deploymentService;
    protected DeploymentStatusTracker tracker;

    public StartupSummaryDeploymentListener(DeploymentStatusTracker tracker, DeploymentService deploymentService) {
        this.tracker = tracker;
        this.deploymentService = deploymentService;
    }

    @Override
    public void onAfterStartup() {
        Map<String, ArtifactDeploymentStatusTracker.DeploymentState> domainDeploymentState = this.tracker.getDomainDeploymentStatusTracker().getDeploymentStates();
        String message = domainDeploymentState.isEmpty() ? this.createOnlyAppsTablesLogMessage() : this.createDomainsAndAppsTablesLogMessage(domainDeploymentState);
        SPLASH_LOGGER.info(message);
    }

    private String createOnlyAppsTablesLogMessage() {
        Map<String, ArtifactDeploymentStatusTracker.DeploymentState> applicationStates = this.tracker.getApplicationDeploymentStatusTracker().getDeploymentStates();
        SimpleLoggingTable applicationTable = new SimpleLoggingTable();
        applicationTable.addColumn(APPLICATION_LABEL, 45);
        applicationTable.addColumn(STATUS_LABEL, 18);
        String message = "";
        for (Map.Entry<String, ArtifactDeploymentStatusTracker.DeploymentState> applicationState : applicationStates.entrySet()) {
            String[] data = new String[]{applicationState.getKey(), applicationState.getValue().toString()};
            applicationTable.addDataRow(data);
            message = String.format("%n%s", applicationTable);
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    private String createDomainsAndAppsTablesLogMessage(Map<String, ArtifactDeploymentStatusTracker.DeploymentState> domainDeploymentState) {
        void var5_9;
        MultiMap<String, String> applicationsPerDomain = new MultiMap<String, String>();
        SimpleLoggingTable domainTable = new SimpleLoggingTable();
        domainTable.addColumn(DOMAIN_OWNER_LABEL, 45);
        domainTable.addColumn(STATUS_LABEL, 18);
        for (String string : domainDeploymentState.keySet()) {
            String[] data = new String[]{string, domainDeploymentState.get(string).toString()};
            domainTable.addDataRow(data);
        }
        Map<String, ArtifactDeploymentStatusTracker.DeploymentState> applicationStates = this.tracker.getApplicationDeploymentStatusTracker().getDeploymentStates();
        for (String applicationName : applicationStates.keySet()) {
            Application application = this.deploymentService.findApplication(applicationName);
            String domainName = UNKNOWN_ARTIFACT_NAME;
            if (application != null) {
                domainName = application.getDomain().getArtifactName();
            }
            applicationsPerDomain.put(domainName, applicationName);
        }
        if (!applicationsPerDomain.isEmpty()) {
            SimpleLoggingTable applicationTable = new SimpleLoggingTable();
            applicationTable.addColumn(APPLICATION_LABEL, 45);
            applicationTable.addColumn(DOMAIN_OWNER_LABEL, 30);
            applicationTable.addColumn(STATUS_LABEL, 18);
            for (String domainName : applicationsPerDomain.keySet()) {
                for (String app : applicationsPerDomain.getAll(domainName)) {
                    String[] data = new String[]{app, domainName, applicationStates.get(app).toString()};
                    applicationTable.addDataRow(data);
                }
            }
            String string = String.format("%n%s%n%s", domainTable, applicationTable);
        } else {
            String string = String.format("%n%s", domainTable);
        }
        return var5_9;
    }
}

