/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.streaming.StreamCloserService;
import org.mule.runtime.core.internal.util.StreamCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class DefaultStreamCloserService
implements StreamCloserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultStreamCloserService.class);
    private StreamCloser coreStreamTypesCloser = new CoreStreamTypesCloser();
    private Collection<StreamCloser> allStreamClosers = Collections.emptySet();

    @Override
    public void closeStream(Object stream) {
        block6: {
            try {
                if (this.coreStreamTypesCloser.canClose(stream.getClass())) {
                    this.coreStreamTypesCloser.close(stream);
                } else {
                    for (StreamCloser closer : this.getAllStreamClosers()) {
                        if (!closer.canClose(stream.getClass())) continue;
                        closer.close(stream);
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Unable to find a StreamCloser for the stream type: %s , the stream will not be closed.", stream.getClass()));
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug(String.format("Exception closing stream of class %s", stream.getClass()), (Throwable)e);
            }
        }
    }

    private Collection<StreamCloser> getAllStreamClosers() throws Exception {
        return this.allStreamClosers;
    }

    @Inject
    public void setAllStreamClosers(Optional<Collection<StreamCloser>> allStreamClosers) {
        this.allStreamClosers = allStreamClosers.orElse(Collections.emptySet());
    }

    static class CoreStreamTypesCloser
    implements StreamCloser {
        CoreStreamTypesCloser() {
        }

        public boolean canClose(Class streamType) {
            return InputStream.class.isAssignableFrom(streamType) || InputSource.class.isAssignableFrom(streamType) || StreamSource.class.isAssignableFrom(streamType) || org.mule.runtime.core.api.Closeable.class.isAssignableFrom(streamType) || Closeable.class.isAssignableFrom(streamType) || SAXSource.class.isAssignableFrom(streamType) && !streamType.getName().endsWith("StaxSource");
        }

        @Override
        public void close(Object stream) throws IOException {
            if (stream instanceof InputStream) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    this.logCloseException(stream, e);
                }
            } else if (stream instanceof InputSource) {
                this.closeInputSourceStream((InputSource)stream);
            } else if (stream instanceof SAXSource) {
                this.closeInputSourceStream(((SAXSource)stream).getInputSource());
            } else if (stream instanceof StreamSource) {
                try {
                    ((StreamSource)stream).getInputStream().close();
                }
                catch (IOException e) {
                    this.logCloseException(stream, e);
                }
            } else if (stream instanceof org.mule.runtime.core.api.Closeable) {
                try {
                    ((org.mule.runtime.core.api.Closeable)stream).close();
                }
                catch (MuleException e) {
                    this.logCloseException(stream, e);
                }
            } else if (stream instanceof Closeable) {
                try {
                    ((Closeable)stream).close();
                }
                catch (Exception e) {
                    this.logCloseException(stream, e);
                }
            }
        }

        private void closeInputSourceStream(InputSource payload) throws IOException {
            if (payload.getByteStream() != null) {
                payload.getByteStream().close();
            } else if (payload.getCharacterStream() != null) {
                payload.getCharacterStream().close();
            }
        }

        private void logCloseException(Object stream, Throwable e) {
            if (log.isWarnEnabled()) {
                log.warn("Exception was found trying to close resource of class " + stream.getClass().getCanonicalName(), e);
            }
        }
    }
}

