/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.MessageProcessingManager;
import org.mule.runtime.core.internal.execution.PollItemInformation;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.core.internal.util.func.Once;
import org.mule.runtime.core.internal.util.mediatype.PayloadMediaTypeResolver;
import org.mule.runtime.core.privileged.transaction.TransactionConfig;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionNotificationFunction;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionsFlowProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.source.trace.SourceDistributedTraceContextManager;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionSourceBinder;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;

class DefaultSourceCallback<T, A>
implements SourceCallbackAdapter<T, A> {
    private SourceModel sourceModel;
    private Set<String> notificationModelNames;
    private ConfigurationInstance configurationInstance;
    private Processor listener;
    private Charset defaultEncoding;
    private String applicationName;
    private NotificationDispatcher notificationDispatcher;
    private ExtensionMessageSource messageSource;
    private ExceptionCallback<ConnectionException> exceptionCallback;
    private MessageProcessingManager messageProcessingManager;
    private MessageProcessContext messageProcessContext;
    private SourceCompletionHandlerFactory completionHandlerFactory;
    private CursorProviderFactory cursorProviderFactory;
    private TransactionConfig transactionConfig;
    private boolean returnsListOfMessages = false;
    private MediaType defaultMediaType;
    private TransactionSourceBinder transactionSourceBinder;
    private final ProfilingService profilingService;
    private MediaType mimeTypeInitParam;
    private Charset encodingParam;
    private boolean errorAfterTimeout;
    private final Once.RunOnce resolveInitializationParams = Once.of(() -> {
        Map<String, Object> initialisationParameters = this.messageSource.getInitialisationParameters();
        String encoding = (String)initialisationParameters.get("outputEncoding");
        this.encodingParam = encoding != null ? MediaTypeUtils.parseCharset(encoding) : this.defaultEncoding;
        String mimeType = (String)initialisationParameters.get("outputMimeType");
        if (mimeType != null) {
            this.mimeTypeInitParam = MediaType.parseDefinedInApp(mimeType);
        }
    });

    static Builder builder(ProfilingService profilingService) {
        return new Builder(profilingService);
    }

    private DefaultSourceCallback(ProfilingService profilingService) {
        this.profilingService = profilingService;
    }

    @Override
    public void handle(Result<T, A> result) {
        this.handle(result, this.createContext());
    }

    @Override
    public void handle(Result<T, A> result, SourceCallbackContext context) {
        this.resolveInitializationParams.runOnce();
        Preconditions.checkArgument(context instanceof SourceCallbackContextAdapter, "The supplied context was not created through this callback, you naughty developer");
        SourceCallbackContextAdapter contextAdapter = (SourceCallbackContextAdapter)context;
        this.validateNotifications(contextAdapter);
        MediaType mediaType = this.resolveMediaType(result);
        PayloadMediaTypeResolver payloadMediaTypeResolver = new PayloadMediaTypeResolver(this.defaultEncoding, this.defaultMediaType, this.encodingParam, this.mimeTypeInitParam);
        String name = null;
        HashMap<String, String> attributes = new HashMap();
        DistributedTraceContextManager distributedTraceContextManager = context.getDistributedSourceTraceContext();
        if (distributedTraceContextManager instanceof SourceDistributedTraceContextManager) {
            SourceDistributedTraceContextManager distributedSourceTraceContextManager = (SourceDistributedTraceContextManager)distributedTraceContextManager;
            name = distributedSourceTraceContextManager.getSpanName();
            attributes = distributedSourceTraceContextManager.getSpanRootAttributes();
        }
        SourceResultAdapter resultAdapter = new SourceResultAdapter(result, this.cursorProviderFactory, mediaType, this.returnsListOfMessages, context.getCorrelationId(), payloadMediaTypeResolver, context.getDistributedSourceTraceContext(), name, attributes, context.getVariable("mule-polling-source-accepted-poll-item-information").map(PollItemInformation.class::cast));
        this.executeFlow(context, this.messageProcessContext, resultAdapter, distributedTraceContextManager);
        contextAdapter.dispatched();
    }

    private void validateNotifications(SourceCallbackContextAdapter contextAdapter) {
        contextAdapter.getNotificationsFunctions().forEach(sourceNotification -> {
            String notificationName = ((ExtensionNotificationFunction)sourceNotification).getActionName();
            Preconditions.checkArgument(this.notificationModelNames.contains(notificationName), () -> String.format("Cannot fire notification '%s' since it's not declared by the component.", notificationName));
        });
    }

    private void executeFlow(SourceCallbackContext context, MessageProcessContext messageProcessContext, SourceResultAdapter resultAdapter, DistributedTraceContextManager distributedSourceTraceContextManager) {
        SourceCallbackContextAdapter contextAdapter = (SourceCallbackContextAdapter)context;
        this.messageProcessingManager.processMessage(new ExtensionsFlowProcessingTemplate(resultAdapter, this.listener, contextAdapter.getNotificationsFunctions(), this.completionHandlerFactory.createCompletionHandler(contextAdapter)), messageProcessContext, distributedSourceTraceContextManager);
    }

    protected MediaType resolveMediaType(Object value) {
        Charset existingEncoding = this.encodingParam;
        MediaType mediaType = this.mimeTypeInitParam;
        if (mediaType == null) {
            Result result;
            Optional<MediaType> optionalMediaType;
            if (value instanceof Result && (optionalMediaType = (result = (Result)value).getMediaType()).isPresent()) {
                mediaType = optionalMediaType.get();
                existingEncoding = mediaType.getCharset().orElse(existingEncoding);
            }
            if (mediaType == null) {
                mediaType = this.defaultMediaType;
            }
        }
        return mediaType.withCharset(existingEncoding);
    }

    @Override
    public void onConnectionException(ConnectionException e) {
        this.exceptionCallback.onException(e);
    }

    @Override
    public SourceCallbackContext createContext() {
        return new DefaultSourceCallbackContext(this, this.profilingService, this.errorAfterTimeout);
    }

    @Override
    public TransactionSourceBinder getTransactionSourceBinder() {
        return this.transactionSourceBinder;
    }

    @Override
    public ConfigurationInstance getConfigurationInstance() {
        return this.configurationInstance;
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public SourceConnectionManager getSourceConnectionManager() {
        return this.messageSource.getSourceConnectionManager();
    }

    @Override
    public String getOwningSourceName() {
        return this.sourceModel.getName();
    }

    @Override
    public String getOwningExtensionName() {
        return this.messageSource.getExtensionModel().getName();
    }

    @Override
    public ComponentLocation getSourceLocation() {
        return this.messageSource.getLocation();
    }

    @Override
    public int getTimeout() {
        return this.getTransactionConfig().getTimeout();
    }

    static class Builder<T, A> {
        private final DefaultSourceCallback<T, A> product;

        private Builder(ProfilingService profilingService) {
            this.product = new DefaultSourceCallback(profilingService);
        }

        public Builder<T, A> setSourceModel(SourceModel sourceModel) {
            this.product.sourceModel = sourceModel;
            this.product.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages(sourceModel);
            this.product.defaultMediaType = org.mule.runtime.module.extension.internal.util.MediaTypeUtils.getDefaultMediaType(sourceModel);
            this.product.notificationModelNames = sourceModel.getNotificationModels().stream().map(NotificationModel::getIdentifier).collect(Collectors.toSet());
            return this;
        }

        public Builder<T, A> setConfigurationInstance(ConfigurationInstance configurationInstance) {
            this.product.configurationInstance = configurationInstance;
            return this;
        }

        public Builder<T, A> setTransactionConfig(TransactionConfig transactionConfig) {
            this.product.transactionConfig = transactionConfig;
            return this;
        }

        public Builder<T, A> setListener(Processor listener) {
            this.product.listener = listener;
            return this;
        }

        public Builder<T, A> setDefaultEncoding(Charset defaultEncoding) {
            this.product.defaultEncoding = defaultEncoding;
            return this;
        }

        public Builder<T, A> setApplicationName(String applicationName) {
            this.product.applicationName = applicationName;
            return this;
        }

        public Builder<T, A> setNotificationDispatcher(NotificationDispatcher notificationDispatcher) {
            this.product.notificationDispatcher = notificationDispatcher;
            return this;
        }

        public Builder<T, A> setSource(ExtensionMessageSource messageSource) {
            this.product.messageSource = messageSource;
            return this;
        }

        public Builder<T, A> setExceptionCallback(ExceptionCallback<ConnectionException> exceptionCallback) {
            this.product.exceptionCallback = exceptionCallback;
            return this;
        }

        public Builder<T, A> setProcessingManager(MessageProcessingManager processingManager) {
            this.product.messageProcessingManager = processingManager;
            return this;
        }

        public Builder<T, A> setProcessContext(MessageProcessContext processContext) {
            this.product.messageProcessContext = processContext;
            return this;
        }

        public Builder<T, A> setCompletionHandlerFactory(SourceCompletionHandlerFactory completionHandlerFactory) {
            this.product.completionHandlerFactory = completionHandlerFactory;
            return this;
        }

        public Builder<T, A> setCursorStreamProviderFactory(CursorProviderFactory cursorProviderFactory) {
            this.product.cursorProviderFactory = cursorProviderFactory;
            return this;
        }

        public Builder<T, A> setErrorAfterTimeout(boolean errorAfterTimeout) {
            this.product.errorAfterTimeout = errorAfterTimeout;
            return this;
        }

        public SourceCallback<T, A> build() {
            this.checkArgument(this.product.listener, "listener");
            this.checkArgument(this.product.exceptionCallback, "exceptionCallback");
            this.checkArgument(this.product.messageProcessingManager, "messageProcessingManager");
            this.checkArgument(this.product.messageProcessContext, "processContext");
            this.checkArgument(this.product.completionHandlerFactory, "completionHandlerSupplier");
            this.checkArgument(this.product.sourceModel, "source");
            this.checkArgument(this.product.cursorProviderFactory, "cursorStreamProviderFactory");
            this.checkArgument(this.product.messageSource, "messageSource");
            this.checkArgument(this.product.applicationName, "applicationName");
            this.checkArgument(this.product.notificationDispatcher, "notificationDispatcher");
            this.product.transactionSourceBinder = new TransactionSourceBinder(this.product.messageSource.getExtensionModel(), this.product.sourceModel, this.product.applicationName, this.product.notificationDispatcher);
            return this.product;
        }

        private void checkArgument(Object value, String name) {
            Preconditions.checkArgument(value != null, name + " was not set");
        }
    }
}

