/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.editors;

import java.beans.PropertyEditor;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.config.internal.editors.DatePropertyEditor;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;

public class MulePropertyEditorRegistrar
implements PropertyEditorRegistrar {
    private Map<Class<?>, Class<PropertyEditor>> customPropertyEditorsCache;
    private static final String CUSTOM_PROPERTY_EDITOR_RESOURCE_NAME = "META-INF/mule.custom-property-editors";
    private final DatePropertyEditor datePropertyEditor = new DatePropertyEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd hh:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), true);

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        registry.registerCustomEditor(Date.class, (PropertyEditor)this.datePropertyEditor);
        if (this.customPropertyEditorsCache == null) {
            this.discoverCustomPropertyEditor();
        }
        for (Map.Entry<Class<?>, Class<PropertyEditor>> entry : this.customPropertyEditorsCache.entrySet()) {
            try {
                PropertyEditor customEditor = entry.getValue().getConstructor(new Class[0]).newInstance(new Object[0]);
                registry.registerCustomEditor(entry.getKey(), customEditor);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading custom property editors", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverCustomPropertyEditor() {
        this.customPropertyEditorsCache = new HashMap();
        for (ClassLoader classLoader : MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders()) {
            try {
                Enumeration<URL> urls = classLoader.getResources(CUSTOM_PROPERTY_EDITOR_RESOURCE_NAME);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    Properties props = new Properties();
                    InputStream stream = IOUtils.getInputStreamWithCacheControl(url);
                    try {
                        props.load(stream);
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            String target = (String)entry.getKey();
                            String editor = (String)entry.getValue();
                            Class<?> requiredType = classLoader.loadClass(target);
                            Class<?> propertyEditorClass = classLoader.loadClass(editor);
                            this.customPropertyEditorsCache.put(requiredType, propertyEditorClass);
                        }
                    }
                    finally {
                        org.apache.commons.io.IOUtils.closeQuietly((InputStream)stream);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading custom property editors", e);
            }
        }
    }
}

