/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.runtime.core.internal.config.bootstrap.ObjectBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransformerBootstrapProperty;
import org.mule.runtime.core.internal.transformer.TransformerUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class SpringRegistryBootstrap
extends AbstractRegistryBootstrap
implements Initialisable {
    private final BiConsumer<String, BeanDefinition> beanDefinitionRegister;

    public SpringRegistryBootstrap(ArtifactType artifactType, BootstrapServiceDiscoverer bootstrapServiceDiscoverer, BiConsumer<String, BeanDefinition> beanDefinitionRegister, Predicate<String> propertyKeyfilter) {
        super(artifactType, bootstrapServiceDiscoverer, propertyKeyfilter);
        this.beanDefinitionRegister = beanDefinitionRegister;
    }

    @Override
    protected void doRegisterTransformer(TransformerBootstrapProperty bootstrapProperty, Class<?> returnClass, Class<? extends Transformer> transformerClass) throws Exception {
        Object name;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(transformerClass);
        DataType returnType = null;
        if (returnClass != null) {
            DataTypeParamsBuilder dataTypeBuilder = DataType.builder().type(returnClass);
            if (StringUtils.isNotEmpty((CharSequence)bootstrapProperty.getMimeType())) {
                dataTypeBuilder = dataTypeBuilder.mediaType(bootstrapProperty.getMimeType());
            }
            builder.addPropertyValue("returnDataType", (Object)dataTypeBuilder.build());
        }
        if ((name = bootstrapProperty.getName()) == null) {
            name = "_" + TransformerUtils.generateTransformerName(transformerClass, returnType);
        }
        builder.addPropertyValue("name", name);
        this.doRegisterObject((String)name, builder);
    }

    @Override
    protected void doRegisterObject(ObjectBootstrapProperty bootstrapProperty) throws Exception {
        Class clazz = bootstrapProperty.getService().forName(bootstrapProperty.getClassName());
        this.doRegisterObject(bootstrapProperty.getKey(), BeanDefinitionBuilder.rootBeanDefinition((Class)clazz));
    }

    private void doRegisterObject(String key, BeanDefinitionBuilder builder) {
        this.beanDefinitionRegister.accept(key, (BeanDefinition)builder.getBeanDefinition());
    }
}

