/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.logging.otel.impl.configuration.ExporterBackoffConfigurator;
import org.mule.runtime.logging.otel.impl.configuration.LogRecordExporterConfiguratorException;
import org.mule.runtime.logging.otel.impl.configuration.LoggingExporterConfigurator;
import org.mule.runtime.module.observability.configuration.HeadersParser;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class HttpLoggingExporterConfigurator
implements LoggingExporterConfigurator {
    @Override
    public LogRecordExporter configureExporter(ObservabilitySignalConfiguration configuration) throws LogRecordExporterConfiguratorException {
        String timeout;
        String headers;
        String compressionType;
        OtlpHttpLogRecordExporterBuilder httpLogRecordExporterBuilder = OtlpHttpLogRecordExporter.builder();
        String endpoint = configuration.getStringValue("mule.openTelemetry.logging.exporter.endpoint");
        if (!StringUtils.isEmpty((CharSequence)endpoint)) {
            httpLogRecordExporterBuilder.setEndpoint(endpoint);
        }
        if ((compressionType = configuration.getStringValue("mule.openTelemetry.logging.exporter.compression")) != null) {
            httpLogRecordExporterBuilder.setCompression(compressionType);
        }
        if (configuration.getBooleanValue("mule.openTelemetry.logging.exporter.tls.enabled", Boolean.FALSE).booleanValue()) {
            this.configureTls(httpLogRecordExporterBuilder, configuration);
        }
        if ((headers = configuration.getStringValue("mule.openTelemetry.logging.exporter.headers")) != null) {
            this.configureHeaders(httpLogRecordExporterBuilder, headers);
        }
        if ((timeout = configuration.getStringValue("mule.openTelemetry.logging.exporter.timeout")) != null) {
            this.configureTimeout(httpLogRecordExporterBuilder, timeout);
        }
        ExporterBackoffConfigurator.enableBackoffStrategy(httpLogRecordExporterBuilder, configuration);
        return httpLogRecordExporterBuilder.build();
    }

    private void configureTimeout(OtlpHttpLogRecordExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpHttpLogRecordExporterBuilder builder, String headers) throws LogRecordExporterConfiguratorException {
        try {
            HeadersParser.parseHeaders(headers).forEach((arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
        }
        catch (Exception e) {
            throw new LogRecordExporterConfiguratorException(e);
        }
    }

    private void configureTls(OtlpHttpLogRecordExporterBuilder builder, ObservabilitySignalConfiguration configuration) throws LogRecordExporterConfiguratorException {
        HttpLoggingExporterConfigurator.configureTrustedCertificates(builder, configuration);
        this.configureClientTls(builder, configuration);
    }

    private static void configureTrustedCertificates(OtlpHttpLogRecordExporterBuilder builder, ObservabilitySignalConfiguration configuration) throws LogRecordExporterConfiguratorException {
        String caFilePath = configuration.getStringValue("mule.openTelemetry.logging.exporter.tls.caFileLocation");
        if (caFilePath != null) {
            try {
                byte[] caFileBytes = Files.readAllBytes(Paths.get(caFilePath, new String[0]));
                builder.setTrustedCertificates(caFileBytes);
            }
            catch (IOException e) {
                throw new LogRecordExporterConfiguratorException(e);
            }
        }
    }

    private void configureClientTls(OtlpHttpLogRecordExporterBuilder builder, ObservabilitySignalConfiguration configuration) throws LogRecordExporterConfiguratorException {
        String certFilePath = configuration.getStringValue("mule.openTelemetry.logging.exporter.tls.certFileLocation");
        String keyFilePath = configuration.getStringValue("mule.openTelemetry.logging.exporter.tls.keyFileLocation");
        if (certFilePath != null && keyFilePath != null) {
            try {
                byte[] keyFileBytes = Files.readAllBytes(Paths.get(keyFilePath, new String[0]));
                byte[] certFileBytes = Files.readAllBytes(Paths.get(certFilePath, new String[0]));
                builder.setClientTls(keyFileBytes, certFileBytes);
            }
            catch (IOException e) {
                throw new LogRecordExporterConfiguratorException(e);
            }
        }
    }
}

