/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.config.impl;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.observability.AbstractFileObservabilitySignalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMeterExporterConfiguration
extends AbstractFileObservabilitySignalConfiguration {
    private static final String CONFIGURATION_FILE_NAME = "meter-exporter.conf";
    private static final Logger logger = LoggerFactory.getLogger(FileMeterExporterConfiguration.class);
    private final String artifactId;
    private final ConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider());

    public FileMeterExporterConfiguration(MuleContext muleContext) {
        super(path -> FileMeterExporterConfiguration.findArtifactConfigFile(muleContext.getExecutionClassLoader(), path), propertyReference -> new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider()).apply(propertyReference));
        this.artifactId = muleContext.getId();
    }

    @Override
    protected void onConfigurationFileNotFound() {
        logger.atInfo().log("Metric exporter configuration file named '{}' not found {}. Using default configuration.", (Object)this.getSignalConfigurationFileName(), (Object)this.getConfigurationFileLocations());
    }

    private String getConfigurationFileLocations() {
        if (FileMeterExporterConfiguration.isApplicationLevelConfigurable()) {
            return String.format("at at both '%s' artifact resources and the '%s' configuration path", this.artifactId, this.getSignalConfigurationFileDirectoryPath());
        }
        return String.format("at the '%s' configuration path", this.getSignalConfigurationFileDirectoryPath());
    }

    @Override
    protected void onConfigurationFileLoadError(Exception error, File configurationFile) {
        logger.atWarn().log("Meter exporter configuration file at '{}' had a parsing error: {}. Using default configuration.", (Object)configurationFile.getAbsolutePath(), (Object)error.getMessage());
    }

    @Override
    protected String getSignalConfigurationFileName() {
        return CONFIGURATION_FILE_NAME;
    }

    @Override
    protected Path getSignalConfigurationFileDirectoryPath() {
        return Paths.get(System.getProperty("mule.openTelemetry.meter.exporter.configurationFilePath", MuleFoldersUtil.getConfFolder().getAbsolutePath()), new String[0]).toAbsolutePath();
    }
}

